@extends('bloom.layout.admin')

@section('assets')
    @vite('/form.js', '/vendor/cms-module-sante')
    <script src="/plugins/ckeditor/ckeditor.js"></script>
    <script type="text/javascript" src="/js/ckfinder/ckfinder.js"></script>
    <script>CKFinder.config({connectorPath: '/ckfinder/connector'});</script>
@endsection

@section('content')
    @php
        use \Carbon\Carbon;
    @endphp

    @switch($sante->page->statut_id)
        @case(0)
            @php($route = 'archived')
        @case(1)
            @php($route = 'index')
        @case(2)
            @php($route = 'encours')
    @endswitch

    <div class="container-fluid">
        <div id="navbar-btns" class="mb-5 heading-text d-flex justify-content-between align-items-center sticky-top">
            <h1>{{ $sante->exists() ? 'Éditer' : 'Créer' }} un produit</h1>

            <span class="ml-auto">
                <a href="{{ route('admin_sante_' . $route) }}" class="btn btn-grisclair5 btn-primary">
                    Annuler
                </a>
                <a href="javascript:void(0);" class="btn btn-grisclair5 btn-primary" onclick="$('.main form').submit()">
                    Valider
                </a>
                <a href="javascript:void(0);" class="btn btn-grisclair5 btn-primary" onclick="publishAndSubmit()">
                    Valider et publier maintenant
                </a>
                <a href="@if($sante->exists()) {{ route('admin_sante_preview', $sante) }} @else javascript:void(0); @endif"
                   target="_blank" class="btn btn-grisclair5 btn-primary @if(!$sante->exists()) disabled @endif"
                   title="@if(!$sante->exists()) Sauvegarder pour prévisualiser @endif">
                    Prévisualiser
                </a>
            </span>
        </div>

        <div class="content">
            <form action="{{ route('admin_sante_save', $sante) }}" method="POST" id="form"
                  enctype="multipart/form-data">
                <div class="form-group row mb-0">
                    <div class="col-6 mb-4">
                        <x-forms.input-text
                                name="titre"
                                text="Titre"
                                :value="$sante->page->titre"
                                form="admin"
                                :required="true"
                        />
                    </div>

                    <div class="col-6 mb-4">
                        <x-forms.input-text
                                name="slug"
                                text="Slug"
                                :value="$sante->page->slug"
                                form="admin"
                                :required="true"
                        />
                    </div>
                </div>

                <div class="form-group mb-4">
                    <label for="vignette" class="control-label">Vignette</label>
                    <x-forms.input-custom-file-with-image
                            name="vignette"
                            text="Parcourir"
                            form="admin"
                            :required="true"
                            :value="$sante->page->image_opengraph"
                    />
                </div>

                <div class="form-group row mb-0">
                    <div class="col-12 mb-4">
                        <div class="wrapper-editor">
                            <x-forms.editor
                                    name="intro"
                                    text="Introduction <em>(facultatif)</em>"
                                    :value="$sante->page->intro"
                                    form="admin"
                                    format="mini"
                            />
                        </div>
                    </div>

                    <div class="col-12 mb-4">
                        <div class="wrapper-editor">
                            <x-forms.editor
                                    name="contenu"
                                    text="Contenu"
                                    :value="$sante->contenu"
                                    form="admin"
                                    format="full"
                                    :max="10000"
                                    :required="true"
                            />
                        </div>
                    </div>
                </div>

                <div class="accordion mb-4" id="accordionSante">
                    <div class="card b-0 mb-4">
                        <div class="card-header b-0 px-0 bg-none" id="heading01">
                            <h2 class="mb-0">
                                <button class="btn btn-collapse collapsed" type="button" data-toggle="collapse"
                                        data-target="#collapseOne" aria-expanded="false" aria-controls="collapseOne">
                                    <span class="text">SECTION - AVANTAGES -</span>
                                    <span class="fa fa-plus"></span>
                                    <span class="fa fa-minus"></span>
                                </button>
                            </h2>
                        </div>

                        <div id="collapseOne" class="collapse" aria-labelledby="heading01"
                             data-parent="#accordionSante">
                            <div class="card-body px-0">
                                <div class="wrapper-editor mb-4">
                                    <x-forms.editor
                                            name="avantage"
                                            text="Contenu"
                                            :value="$sante->avantage"
                                            form="admin"
                                            format="no_replaceContent"
                                            :max="10000"
                                            :required="true"
                                    />
                                </div>

                                <div class="form-group row mb-0">
                                    <div class="col-6">
                                        <x-forms.input-custom-switch
                                                name="avt_lien1"
                                                id="lien01-heading01"
                                                :checked="!is_null($sante->avt_lien1)"
                                                url=""
                                                text="Lien 1"
                                        />
                                    </div>
                                </div>

                                <div class="wrapper-exergue wrapper01-heading01 mb-4">
                                    <div class="form-group row mb-4">
                                        <div class="col-6">
                                            <x-forms.input-text
                                                    name="avt_lien1_libelle"
                                                    text="Libellé"
                                                    :value="$sante->avantage1->libelle"
                                                    form="admin"
                                                    :required="true"
                                                    :disabled="true"
                                            />
                                        </div>
                                    </div>
                                    <div class="form-group row mb-0">
                                        <div class="col-6">
                                            <x-forms.input-custom-radio
                                                    name="link_choice_avt_lien1"
                                                    text="Interne"
                                                    value="interne"
                                                    form="admin"
                                                    :checked="true"
                                                    :required="false"
                                                    :inline="!isset($node->id)"
                                            />
                                            <select class="form-control" name="avt_lien1_page_id" id="avt_lien1_page_id"
                                                    required="required">
                                                <option value="">Liste des liens disponibles</option>
                                                <x-modules.sante-pages-options
                                                        :node="$node"
                                                        :attr="$sante->avt_lien1"
                                                />
                                            </select>
                                        </div>

                                        <div class="col-6">
                                            <x-forms.input-custom-radio
                                                    name="link_choice_avt_lien1"
                                                    text="Externe"
                                                    value="externe"
                                                    form="admin"
                                                    :checked="true"
                                                    :required="false"
                                                    :inline="!isset($sante->avantage1->href)"
                                            />
                                            <x-forms.input-text
                                                    name="avt_lien1_href"
                                                    text=""
                                                    :value="$sante->avantage1->href"
                                                    :required="true"
                                                    :disabled="true"
                                            />
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group row mb-0">
                                    <div class="col-6">
                                        <x-forms.input-custom-switch
                                                name="avt_lien2"
                                                id="lien02-heading01"
                                                :checked="!is_null($sante->avt_lien2)"
                                                url=""
                                                text="Lien 2"
                                        />
                                    </div>
                                </div>

                                <div class="wrapper-exergue wrapper02-heading01">
                                    <div class="form-group row mb-4">
                                        <div class="col-6">
                                            <x-forms.input-text
                                                    name="avt_lien2_libelle"
                                                    text="Libellé"
                                                    :value="$sante->avantage2->libelle"
                                                    :required="true"
                                                    :disabled="true"
                                            />
                                        </div>
                                    </div>
                                    <div class="form-group row mb-0">
                                        <div class="col-6">
                                            <x-forms.input-custom-radio
                                                    name="link_choice_avt_lien2"
                                                    text="Interne"
                                                    value="interne"
                                                    form="admin"
                                                    :checked="true"
                                                    :required="false"
                                                    :inline="!isset($sante->avantage2->page_id)"
                                            />
                                            <select class="form-control" name="avt_lien2_page_id" id="avt_lien2_page_id"
                                                    required="required">
                                                <option value="">Liste des liens disponibles</option>
                                                <x-modules.sante-pages-options
                                                        :node="$node"
                                                        :attr="$sante->avt_lien2"
                                                />
                                            </select>
                                        </div>

                                        <div class="col-6">
                                            <x-forms.input-custom-radio
                                                    name="link_choice_avt_lien2"
                                                    text="Externe"
                                                    value="externe"
                                                    form="admin"
                                                    :checked="true"
                                                    :required="false"
                                                    :inline="!isset($sante->avantage2->href)"
                                            />
                                            <x-forms.input-text
                                                    name="avt_lien2_href"
                                                    text=""
                                                    :value="$sante->avantage2->href"
                                                    :required="true"
                                                    :disabled="true"
                                            />
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card b-0 mb-4">
                        <div class="card-header b-0 px-0 bg-none" id="heading02">
                            <h2 class="mb-0">
                                <button class="btn btn-collapse collapsed" type="button" data-toggle="collapse"
                                        data-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                    <span class="text">SECTION - PLUS REMPART -</span>
                                    <span class="fa fa-plus"></span>
                                    <span class="fa fa-minus"></span>
                                </button>
                            </h2>
                        </div>
                        <div id="collapseTwo" class="collapse" aria-labelledby="heading02"
                             data-parent="#accordionSante">
                            <div class="card-body px-0">
                                <div class="wrapper-editor mb-4">
                                    <x-forms.editor
                                            name="plus_rempart"
                                            text="Contenu"
                                            :value="$sante->plus_rempart"
                                            form="admin"
                                            format="no_replaceContent"
                                            :max="10000"
                                            :required="true"
                                    />
                                </div>

                                <div class="form-group row mb-0">
                                    <div class="col-6">
                                        <x-forms.input-custom-switch
                                                name="plus_lien1"
                                                id="lien01-heading02"
                                                :checked="!is_null($sante->plus_lien1)"
                                                url=""
                                                text="Lien 1"
                                        />
                                    </div>
                                </div>

                                <div class="wrapper-exergue wrapper01-heading02 mb-4">
                                    <div class="form-group row mb-4">
                                        <div class="col-6">
                                            <x-forms.input-text
                                                    name="plus_lien1_libelle"
                                                    text="Libellé"
                                                    :value="$sante->plus1->libelle"
                                                    form="admin"
                                                    :required="true"
                                                    :disabled="true"
                                            />
                                        </div>
                                    </div>
                                    <div class="form-group row mb-0">
                                        <div class="col-6">
                                            <x-forms.input-custom-radio
                                                    name="link_choice_plus_lien1"
                                                    text="Interne"
                                                    value="interne"
                                                    form="admin"
                                                    :checked="true"
                                                    :required="false"
                                                    :inline="!isset($sante->plus1->page_id)"
                                            />
                                            <select class="form-control" name="plus_lien1_page_id"
                                                    id="plus_lien1_page_id" required="required">
                                                <option value="">Liste des liens disponibles</option>
                                                <x-modules.sante-pages-options
                                                        :node="$node"
                                                        :attr="$sante->plus_lien1"
                                                />
                                            </select>
                                        </div>

                                        <div class="col-6">
                                            <x-forms.input-custom-radio
                                                    name="link_choice_plus_lien1"
                                                    text="Externe"
                                                    value="externe"
                                                    form="admin"
                                                    :checked="true"
                                                    :required="false"
                                                    :inline="!isset($sante->plus1->href)"
                                            />
                                            <x-forms.input-text
                                                    name="plus_lien1_href"
                                                    text=""
                                                    :value="$sante->plus1->href"
                                                    :required="true"
                                                    :disabled="true"
                                            />
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group row mb-0">
                                    <div class="col-6">
                                        <x-forms.input-custom-switch
                                                name="plus_lien2"
                                                id="lien02-heading02"
                                                :checked="!is_null($sante->plus_lien2)"
                                                url=""
                                                text="Lien 2"
                                        />
                                    </div>
                                </div>

                                <div class="wrapper-exergue wrapper02-heading02 mb-4">
                                    <div class="form-group row mb-4">
                                        <div class="col-6">
                                            <x-forms.input-text
                                                    name="plus_lien2_libelle"
                                                    text="Libellé"
                                                    :value="$sante->plus2->libelle"
                                                    form="admin"
                                                    :required="true"
                                                    :disabled="true"
                                            />
                                        </div>
                                    </div>
                                    <div class="form-group row mb-0">
                                        <div class="col-6">
                                            <x-forms.input-custom-radio
                                                    name="link_choice_plus_lien2"
                                                    text="Interne"
                                                    value="interne"
                                                    form="admin"
                                                    :checked="true"
                                                    :required="false"
                                                    :inline="!isset($sante->plus2->page_id)"
                                            />
                                            <select class="form-control" name="plus_lien2_page_id"
                                                    id="plus_lien2_page_id" required="required">
                                                <option value="">Liste des liens disponibles</option>
                                                <x-modules.sante-pages-options
                                                        :node="$node"
                                                        :attr="$sante->plus_lien2"
                                                />
                                            </select>
                                        </div>

                                        <div class="col-6">
                                            <x-forms.input-custom-radio
                                                    name="link_choice_plus_lien2"
                                                    text="Externe"
                                                    value="externe"
                                                    form="admin"
                                                    :checked="true"
                                                    :required="false"
                                                    :inline="!isset($sante->plus2->href)"
                                            />
                                            <x-forms.input-text
                                                    name="plus_lien2_href"
                                                    text=""
                                                    :value="$sante->plus2->href"
                                                    :required="true"
                                                    :disabled="true"
                                            />
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card b-0 mb-4">
                        <div class="card-header b-0 px-0 bg-none" id="heading03">
                            <h2 class="mb-0">
                                <button class="btn btn-collapse collapsed" type="button" data-toggle="collapse"
                                        data-target="#collapseThree" aria-expanded="false"
                                        aria-controls="collapseThree">
                                    <span class="text">SECTION - GARANTIES -</span>
                                    <span class="fa fa-plus"></span>
                                    <span class="fa fa-minus"></span>
                                </button>
                            </h2>
                        </div>
                        <div id="collapseThree" class="collapse" aria-labelledby="heading03"
                             data-parent="#accordionSante">
                            <div class="card-body px-0">
                                <div class="form-group mb-0">
                                    <label for="titre-niveau01-heading03" class="control-label">Niveau 1</label>
                                </div>

                                <div class="wrapper-exergue wrapper01-heading03">
                                    <div class="form-group row mb-4">
                                        <div class="col-6">
                                            <x-forms.input-text
                                                    name="garantie1_intitule"
                                                    text="Intitulé du niveau"
                                                    :value="$sante->garantie_1->intitule"
                                                    :required="true"
                                            />
                                        </div>
                                    </div>

                                    <div class="wrapper-editor mb-0">
                                        <x-forms.editor
                                                name="garantie1_details"
                                                text="Détails"
                                                :value="$sante->garantie_1->details"
                                                form="admin"
                                                format="full"
                                                :max="10000"
                                                :required="true"
                                        />
                                    </div>
                                </div>

                                <div class="form-group mb-0 mt-4">
                                    <x-forms.input-custom-switch
                                            name="garantie2"
                                            id="niveau02-heading03"
                                            :checked="!is_null($sante->garantie2)"
                                            url=""
                                            text="Niveau 2"
                                    />
                                </div>

                                <div class="wrapper-exergue wrapper02-heading03">
                                    <div class="form-group row mb-4">
                                        <div class="col-6">
                                            <x-forms.input-text
                                                    name="garantie2_intitule"
                                                    text="Intitulé du niveau"
                                                    :value="$sante->garantie_2->intitule"
                                                    :required="true"
                                            />
                                        </div>
                                    </div>

                                    <div class="wrapper-editor mb-0">
                                        <x-forms.editor
                                                name="garantie2_details"
                                                text="Détails"
                                                :value="$sante->garantie_2->details"
                                                form="admin"
                                                format="full"
                                                :max="10000"
                                                :required="true"
                                        />
                                    </div>
                                </div>

                                <div class="form-group mb-0 mt-4">
                                    <x-forms.input-custom-switch
                                            name="garantie3"
                                            id="niveau03-heading03"
                                            :checked="!is_null($sante->garantie3)"
                                            url=""
                                            text="Niveau 3"
                                    />
                                </div>

                                <div class="wrapper-exergue wrapper03-heading03">
                                    <div class="form-group row mb-4">
                                        <div class="col-6">
                                            <x-forms.input-text
                                                    name="garantie3_intitule"
                                                    text="Intitulé du niveau"
                                                    :value="$sante->garantie_3->intitule"
                                                    :required="true"
                                            />
                                        </div>
                                    </div>

                                    <div class="wrapper-editor mb-0">
                                        <x-forms.editor
                                                name="garantie3_details"
                                                text="Détails"
                                                :value="$sante->garantie_3->details"
                                                form="admin"
                                                format="full"
                                                :max="10000"
                                                :required="true"
                                        />
                                    </div>
                                </div>

                                <div class="form-group mb-0 mt-4">
                                    <x-forms.input-custom-switch
                                            name="garantie4"
                                            id="niveau04-heading03"
                                            :checked="!is_null($sante->garantie4)"
                                            url=""
                                            text="Niveau 4"
                                    />
                                </div>

                                <div class="wrapper-exergue wrapper04-heading03">
                                    <div class="form-group row mb-4">
                                        <div class="col-6">
                                            <x-forms.input-text
                                                    name="garantie4_intitule"
                                                    text="Intitulé du niveau"
                                                    :value="$sante->garantie_4->intitule"
                                                    :required="true"
                                            />
                                        </div>
                                    </div>

                                    <div class="wrapper-editor mb-0">
                                        <x-forms.editor
                                                name="garantie4_details"
                                                text="Détails"
                                                :value="$sante->garantie_4->details"
                                                form="admin"
                                                format="full"
                                                :max="10000"
                                                :required="true"
                                        />
                                    </div>
                                </div>

                                <div class="form-group mb-0 mt-4">
                                    <x-forms.input-custom-switch
                                            name="garantie5"
                                            id="niveau05-heading03"
                                            :checked="!is_null($sante->garantie5)"
                                            url=""
                                            text="Niveau 5"
                                    />
                                </div>

                                <div class="wrapper-exergue wrapper05-heading03">
                                    <div class="form-group row mb-4">
                                        <div class="col-6">
                                            <x-forms.input-text
                                                    name="garantie5_intitule"
                                                    text="Intitulé du niveau"
                                                    :value="$sante->garantie_5->intitule"
                                                    :required="true"
                                            />
                                        </div>
                                    </div>

                                    <div class="wrapper-editor mb-0">
                                        <x-forms.editor
                                                name="garantie5_details"
                                                text="Détails"
                                                :value="$sante->garantie_5->details"
                                                form="admin"
                                                format="full"
                                                :max="10000"
                                                :required="true"
                                        />
                                    </div>
                                </div>

                                <hr>

                                <div class="wrapper-inputs custom-file">
                                    <div class="form-group row mb-4">
                                        <div class="col-6">
                                            <label for="brochure" class="control-label">Brochure</label>
                                            <x-forms.input-custom-file2
                                                    name="brochure"
                                                    :text="is_null($sante->brochure) ? 'Parcourir' : $sante->brochure"
                                                    form="admin"
                                                    :required="true"
                                                    :value="$sante->brochure"
                                            />
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card b-0 mb-4">
                        <div class="card-header b-0 px-0 bg-none" id="heading04">
                            <h2 class="mb-0">
                                <button class="btn btn-collapse collapsed" type="button" data-toggle="collapse"
                                        data-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                                    <span class="text">SECTION - EXEMPLES DE REMBOURSEMENT -</span>
                                    <span class="fa fa-plus"></span>
                                    <span class="fa fa-minus"></span>
                                </button>
                            </h2>
                        </div>
                        <div id="collapseFour" class="collapse" aria-labelledby="heading04"
                             data-parent="#accordionSante">
                            <div class="card-body px-0">
                                <div class="form-group mb-0">
                                    <x-forms.input-custom-switch
                                            name="exemple1"
                                            id="example01-heading04"
                                            :checked="!is_null($sante->garantie_1->exemple)"
                                            url=""
                                            text="Exemple 1"
                                    />
                                </div>

                                <div class="wrapper-exergue wrapper01-heading04">
                                    <div class="form-group row mb-4">
                                        <div class="col-6">
                                            <label for="exemple1_image" class="control-label">Image</label>
                                            <x-forms.input-custom-file-with-image
                                                    name="exemple1_image"
                                                    text="Parcourir"
                                                    form="admin"
                                                    :required="true"
                                                    :value="$sante->garantie_1->exemple->image"
                                            />
                                        </div>

                                        <div class="col-6">
                                            <x-forms.input-text
                                                    name="exemple1_titre"
                                                    text="Titre"
                                                    :value="$sante->garantie_1->exemple->titre"
                                                    form="admin"
                                                    :required="true"
                                            />
                                        </div>
                                    </div>

                                    <div class="form-group mb-0">
                                        <div class="wrapper-editor">
                                            <x-forms.editor
                                                    name="exemple1_details"
                                                    text="Détails"
                                                    :value="$sante->garantie_1->exemple->details"
                                                    form="admin"
                                                    format="no_replaceContent"
                                                    :max="2000"
                                                    :required="true"
                                            />
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group mt-4 mb-0">
                                    <x-forms.input-custom-switch
                                            name="exemple2"
                                            id="example02-heading04"
                                            :checked="!is_null($sante->garantie_2->exemple)"
                                            url=""
                                            text="Exemple 2"
                                    />
                                </div>

                                <div class="wrapper-exergue wrapper02-heading04">
                                    <div class="form-group row mb-4">
                                        <div class="col-6">
                                            <label for="exemple2_image" class="control-label">Image</label>
                                            <x-forms.input-custom-file-with-image
                                                    name="exemple2_image"
                                                    text="Parcourir"
                                                    form="admin"
                                                    :required="true"
                                                    :value="$sante->garantie_2->exemple->image"
                                            />
                                        </div>

                                        <div class="col-6">
                                            <x-forms.input-text
                                                    name="exemple2_titre"
                                                    text="Titre"
                                                    :value="$sante->garantie_2->exemple->titre"
                                                    form="admin"
                                                    :required="true"
                                            />
                                        </div>
                                    </div>

                                    <div class="form-group mb-0">
                                        <div class="wrapper-editor">
                                            <x-forms.editor
                                                    name="exemple2_details"
                                                    text="Détails"
                                                    :value="$sante->garantie_2->exemple->details"
                                                    form="admin"
                                                    format="no_replaceContent"
                                                    :max="2000"
                                                    :required="true"
                                            />
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group mt-4 mb-0">
                                    <x-forms.input-custom-switch
                                            name="exemple3"
                                            id="example03-heading04"
                                            :checked="!is_null($sante->garantie_3->exemple)"
                                            url=""
                                            text="Exemple 3"
                                    />
                                </div>

                                <div class="wrapper-exergue wrapper03-heading04">
                                    <div class="form-group row mb-4">
                                        <div class="col-6">
                                            <label for="exemple3_image" class="control-label">Image</label>
                                            <x-forms.input-custom-file-with-image
                                                    name="exemple3_image"
                                                    text="Parcourir"
                                                    form="admin"
                                                    :required="true"
                                                    :value="$sante->garantie_3->exemple->image"
                                            />
                                        </div>

                                        <div class="col-6">
                                            <x-forms.input-text
                                                    name="exemple3_titre"
                                                    text="Titre"
                                                    :value="$sante->garantie_3->exemple->titre"
                                                    form="admin"
                                                    :required="true"
                                            />
                                        </div>
                                    </div>

                                    <div class="form-group mb-0">
                                        <div class="wrapper-editor">
                                            <x-forms.editor
                                                    name="exemple3_details"
                                                    text="Détails"
                                                    :value="$sante->garantie_3->exemple->details"
                                                    form="admin"
                                                    format="no_replaceContent"
                                                    :max="2000"
                                                    :required="true"
                                            />
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group mt-4 mb-0">
                                    <x-forms.input-custom-switch
                                            name="exemple4"
                                            id="example04-heading04"
                                            :checked="!is_null($sante->garantie_4->exemple)"
                                            url=""
                                            text="Exemple 4"
                                    />
                                </div>

                                <div class="wrapper-exergue wrapper04-heading04">
                                    <div class="form-group row mb-4">
                                        <div class="col-6">
                                            <label for="exemple4_image" class="control-label">Image</label>
                                            <x-forms.input-custom-file-with-image
                                                    name="exemple4_image"
                                                    text="Parcourir"
                                                    form="admin"
                                                    :required="true"
                                                    :value="$sante->garantie_4->exemple->image"
                                            />
                                        </div>

                                        <div class="col-6">
                                            <x-forms.input-text
                                                    name="exemple4_titre"
                                                    text="Titre"
                                                    :value="$sante->garantie_4->exemple->titre"
                                                    form="admin"
                                                    :required="true"
                                            />
                                        </div>
                                    </div>

                                    <div class="form-group mb-0">
                                        <div class="wrapper-editor">
                                            <x-forms.editor
                                                    name="exemple4_details"
                                                    text="Détails"
                                                    :value="$sante->garantie_4->exemple->details"
                                                    form="admin"
                                                    format="no_replaceContent"
                                                    :max="2000"
                                                    :required="true"
                                            />
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group mt-4 mb-0">
                                    <x-forms.input-custom-switch
                                            name="exemple5"
                                            id="example05-heading04"
                                            :checked="!is_null($sante->garantie_5->exemple)"
                                            url=""
                                            text="Exemple 5"
                                    />
                                </div>

                                <div class="wrapper-exergue wrapper05-heading04">
                                    <div class="form-group row mb-4">
                                        <div class="col-6">
                                            <label for="exemple5_image" class="control-label">Image</label>
                                            <x-forms.input-custom-file-with-image
                                                    name="exemple5_image"
                                                    text="Parcourir"
                                                    form="admin"
                                                    :required="true"
                                                    :value="$sante->garantie_5->exemple->image"
                                            />
                                        </div>

                                        <div class="col-6">
                                            <x-forms.input-text
                                                    name="exemple5_titre"
                                                    text="Titre"
                                                    :value="$sante->garantie_5->exemple->titre"
                                                    form="admin"
                                                    :required="true"
                                            />
                                        </div>
                                    </div>

                                    <div class="form-group mb-0">
                                        <div class="wrapper-editor">
                                            <x-forms.editor
                                                    name="exemple5_details"
                                                    text="Détails"
                                                    :value="$sante->garantie_5->exemple->details"
                                                    form="admin"
                                                    format="no_replaceContent"
                                                    :max="2000"
                                                    :required="true"
                                            />
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="form-group row mb-0">
                    <div class="col-12 mb-4">
                        <div class="row">
                            <div class="col-6">
                                <select class="form-control" name="dossier_id" id="dossier_id">
                                    <option value="">Localisation dans l'architecture</option>
                                    @foreach($dossiers as $dossier)
                                        <option value="{{ $dossier->id }}"
                                                @if($sante->page->dossier_id === $dossier->id) selected @endif
                                        >
                                            @for($i = $dossier->level; $i < 0; $i--)
                                                >
                                            @endfor
                                            {{ $dossier->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="form-group mb-4">
                    <label class="control-label" for="date_pub">Dates de publication</label>
                    <div class="row w-75">
                        <x-forms.input-date
                                name="date_pub"
                                :value="Carbon::parse($sante->page->to_publish_at)->format('Y-m-d')"
                                placeholder="Début"
                                form="admin"
                        />
                        <x-forms.input-date
                                name="date_depub"
                                :value="Carbon::parse($sante->page->to_unpublish_at)->format('Y-m-d')"
                                placeholder="Fin"
                                form="admin"
                        />
                    </div>
                </div>

                <input type="hidden" name="statut_id" value="{{ $sante->page->statut_id }}">
                {{ csrf_field() }}
            </form>
        </div>
    </div>
@endsection
