<?php
/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

use Bloom\Cms\Configuration\Facade\Site;
use Illuminate\Support\Facades\Route;

Route::group(['middleware' => [function($request, $next) {
    return $next($request)
        ->withCookie(new \Symfony\Component\HttpFoundation\Cookie('CMS_MODULE', 'mea', 0, '/', null,null,false))
        ->withCookie(new \Symfony\Component\HttpFoundation\Cookie('CMS_IMG_L', ( null !== Site::value('VIGNETTE_SANTE_IMG_L') ? Site::value('VIGNETTE_SANTE_IMG_L') : 2000 ),0, '/', null,null,false))
        ->withCookie(new \Symfony\Component\HttpFoundation\Cookie('CMS_IMG_H', ( null !== Site::value('VIGNETTE_SANTE_IMG_H') ? Site::value('VIGNETTE_SANTE_IMG_H') : 1300 ),0, '/', null,null,false)) ; }]], function() {

    Route::get('/', 'AdminController@index')->name('index');
    Route::get('/programmed', 'AdminController@programmed')->name('programmes');
    Route::get('/encours', 'AdminController@encours')->name('encours');
    Route::get('/archived', 'AdminController@archived')->name('archived');
    Route::get('/edit/{sante?}', 'AdminController@edit')->name('edit');
    Route::post('/edit/{sante?}', 'AdminController@save')->name('save');
    Route::get('/{sante}/preview', 'AdminController@preview')->name('preview');
    Route::get('/{sante}/publish', 'AdminController@publish')->name('publish');
    Route::get('/{sante}/unpublish', 'AdminController@unpublish')->name('unpublish');
    Route::get('/{sante}/archive', 'AdminController@archive')->name('archive');
    Route::get('/{sante}/delete', 'AdminController@delete')->name('delete');

});
