<?php

namespace Bloom\CMS\Modules\Sante\Model;

use Bloom\CMS\Modules\Architecture\Model\Lien;
use Bloom\CMS\Modules\Architecture\Model\Statut;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Bloom\CMS\Modules\Architecture\Helpers\IsContenu;
use Bloom\CMS\Modules\Architecture\Contenus\Contenu;
use Bloom\CMS\Modules\Architecture\Http\Controllers\ContenuHandler;
use Bloom\CMS\Modules\Architecture\Model\Page;
use Illuminate\Http\Response;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

/**
 * Class Sante
 * @package Bloom\CMS\Modules\Sante\Model
 *
 * @property string             $contenu
 * @property Page[]|Collection  page
 *
 *
 * @property integer    $id
 * @property string     $avantage
 * @property integer    $avt_lien1
 * @property integer    $avt_lien2
 * @property string     $plus_rempart
 * @property integer    $plus_lien1
 * @property integer    $plus_lien2
 * @property integer    $garantie1
 * @property integer    $garantie2
 * @property integer    $garantie3
 * @property integer    $garantie4
 * @property integer    $garantie5
 * @property string     $brochure
 *
 *
 * @method static Builder|static published()
 * @method static Builder|static archived()
 * @method static Builder|static programmed()
 * @method static Builder|static notProgrammed()
 * @method static Builder|static status(int $status)

 *
 */

class Sante extends Model implements Contenu
{

    use IsContenu;

    protected $table = 'santes';


    public function getHandler(): ContenuHandler
    {
        return new class implements ContenuHandler {

            public function single(Contenu $contenu): Response
            {
                /**
                 * @var Page $page
                 */
                $page = $contenu->page;
                $breadcrumbElements = [["name" => $page->titre, 'url' => '']];
                if ($page->dossier) {
                    $dossier = $page->dossier;
                    while ($dossier !== null) {
                        $breadcrumbElements[] = ['name' => $dossier->name, 'url' => $dossier->full_pathname];
                        $dossier = $dossier->parent;
                    }
                }

                $breadcrumbElements = array_reverse($breadcrumbElements);

                return response(view('produit', ['contenu' => $contenu, 'page' => $page, 'breadcrumbElements' => $breadcrumbElements]));
            }

            public function multiple(Collection $contenus): Response
            {
                // TODO: Implement multiple() method.
            }

            public function ensemble()
            {
                // TODO: Implement ensemble() method.
            }
        };
    }

    public function avantage1(): BelongsTo
    {
        return $this->belongsTo(Lien::class, 'avt_lien1');
    }

    public function avantage2(): BelongsTo
    {
        return $this->belongsTo(Lien::class, 'avt_lien2');
    }

    public function plus1(): BelongsTo
    {
        return $this->belongsTo(Lien::class, 'plus_lien1');
    }

    public function plus2(): BelongsTo
    {
        return $this->belongsTo(Lien::class, 'plus_lien2');
    }

    public function garantie_1(): BelongsTo
    {
        return $this->belongsTo(Garantie::class, 'garantie1');
    }

    public function garantie_2(): BelongsTo
    {
        return $this->belongsTo(Garantie::class, 'garantie2');
    }

    public function garantie_3(): BelongsTo
    {
        return $this->belongsTo(Garantie::class, 'garantie3');
    }

    public function garantie_4(): BelongsTo
    {
        return $this->belongsTo(Garantie::class, 'garantie4');
    }

    public function garantie_5(): BelongsTo
    {
        return $this->belongsTo(Garantie::class, 'garantie5');
    }

    // Scope

    public function scopeStatus(Builder $query, int $status)
    {
        return $query->whereHas('page', function (Builder $query) use ($status) {
            return $query->where('statut_id', '=', $status);
        });
    }

    public function scopePublished(Builder $query)
    {
        return $this->scopeStatus($query, Statut::PUBLIE);
    }

    public function scopeArchived(Builder $query)
    {
        return $this->scopeStatus($query, Statut::ARCHIVE);
    }

    public function scopeProgrammed(Builder $query)
    {
        return $query->whereHas('page', function (Builder $query) {
            return $query->whereNotNull('to_publish_at')
                ->where('statut_id', '=', Statut::EN_COURS);
        });
    }

    public function scopeNotProgrammed(Builder $query)
    {
        return $query->whereHas('page', function (Builder $query) {
            return $query->whereNull('to_publish_at');
        });
    }

}
