<?php

namespace Bloom\CMS\Modules\Sante\Model;

use Bloom\CMS\Modules\Sante\Model\Exemple;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * Class Garantie
 * @package Bloom\MutuelleDuRempart\Model
 *
 * @property integer    $id
 * @property string     $intitule
 * @property string     $details
 * @property integer    $exemple
 *
 */

class Garantie extends Model
{
    protected $table = 'ps_garanties';

    public function exemple(): BelongsTo
    {
        return $this->belongsTo(Exemple::class, 'exemple_id');
    }

}
