<?php

use Bloom\CMS\Modules\Architecture\Model\Page;
use Bloom\CMS\Modules\Sante\Model\Sante;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class SantePolymoph extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $santes = Sante::all();

        foreach ($santes as $sante) {
            /**
             * @var Page    $page
             */
            $page = Page::find($sante->page_id);
            if ($page) {
                $page->contenu()->associate($sante);
                $page->save();
            }
        }

        Schema::table('produit_santes', function (Blueprint $table) {
           $table->dropColumn('page_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('produit_santes', function (Blueprint $table) {
            $table->integer('page_id', false, true)->after('id');
        });
    }
}
