<?php
/**
 * Created by : jérôme
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

namespace Bloom\CMS\Modules\Sante\Http\Controllers;


use Bloom\CMS\Core\Helpers\Actions;
use Bloom\CMS\Core\Http\Dossier;
use Bloom\CMS\Core\Http\Lien;
use Bloom\CMS\Core\Httpl\Miroir;
use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\Core\Contenus\Statut;
use Bloom\CMS\Modules\Sante\Model\Exemple;
use Bloom\CMS\Modules\Sante\Model\Garantie;
use Bloom\CMS\Modules\Sante\Model\Node;
use Bloom\CMS\Modules\Sante\Model\Sante;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Routing\Controller;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Auth;


class AdminController extends Controller
{

    public function getSubMenu(): array
    {
        return [
            'sub_menu_items' => [
                [
                    'title'  => 'Publiés',
                    'href'   => route('admin_sante_index'),
                    'number' => Sante::published()->count(),
                    'active' => request()->route()->getName() === 'admin_sante_index',
                ],
                [
                    'title'  => 'En cours de rédaction',
                    'href'   => route('admin_sante_encours'),
                    'number' => Sante::status(Statut::EN_COURS)->notProgrammed()->count(),
                    'active' => request()->route()->getName() === 'admin_sante_encours',
                ],
                [
                    'title'  => 'Archivés',
                    'href'   => route('admin_sante_archived'),
                    'number' => Sante::archived()->count(),
                    'active' => request()->route()->getName() === 'admin_sante_archived',
                ],
            ]
        ];
    }

    public function getViewData(array $data): array
    {
        return array_merge($data, $this->getSubMenu());
    }

    public function getDefaultActions(bool $with_sub = true): array
    {
        $actions = new Actions();
        $actions
            ->addAction('Modifier', 'admin_sante_edit')
            ->addNewTabAction('Prévisualiser', 'admin_sante_preview')
            ->addAction('Publier', 'admin_sante_publish');
        if ($with_sub) {
            $sub_actions = new Actions('sub_actions');
            $sub_actions
                ->addAction('Archiver', 'admin_sante_archive');
        }

        return array_merge($actions->toArray(), isset($sub_actions) ? $sub_actions->toArray() : []);
    }

    public function getSorted(Collection $collection)
    {
        $collection->load('page');
        $sort = function (Sante $sante) {
            return Arr::get(Arr::dot($sante->toArray()), request('orderBy', 'id'));
        };

        return [
            'santes' => request('order', 'asc') === "asc" ?
                $collection->sortBy($sort) :
                $collection->sortByDesc($sort),
            'order'  => [
                'item'  => request('orderBy', 'id'),
                'order' => request('order', 'asc'),
            ]
        ];
    }

    public function index()
    {
        $actions = $this->getDefaultActions();

        // On remplace la 3ieme action du menu
        $actions['actions'][2] = [
            'name' => 'Dépublier', 'href' => 'admin_sante_unpublish'
        ];

        $data = array_merge($this->getSorted(Sante::published()->get()), $actions);

        return view('Sante::admin.listing', $this->getViewData($data));
    }

    public function encours()
    {
        $data = array_merge($this->getSorted(Sante::status(2)->notProgrammed()->get()), $this->getDefaultActions());

        return view('Sante::admin.listing', $this->getViewData($data));
    }

    public function archived()
    {
        $data = array_merge(
            $this->getSorted(Sante::archived()->get()),
            (new Actions())
                ->addAction('Prévisualiser', 'admin_sante_preview')
                ->addAction('Désarchiver', 'admin_sante_unpublish')->toArray()
        );

        return view('Sante::admin.listing', $this->getViewData($data));
    }

    public function buildPage(Page $page, Miroir $pageDossier = null): Node
    {
        $node = new Node();
        if ($pageDossier) {
            $node->id = $pageDossier->id;
            $node->type = "miroir";
        } else {
            $node->id = $page->id;
            $node->type = "pages";
        }
        $node->title = $page->titre;

        return $node;
    }

    public function buildTree(Dossier $dossier): ?Node
    {
        $node = new Node();
        $node->type = "pages";

        $index = $dossier->pages()
            ->where('is_index', '=', 1)
            ->where('statut_id', '=', Statut::PUBLIE)
            ->first();
        if ($index == null || !$index->exists) {
            return null;
        }
        $pages = $dossier->pages()
            ->where('statut_id', '=', Statut::PUBLIE)
            ->get();
        foreach ($pages as $page) {
            if ($page->is_index) {
                $node->title = $page->titre;
                $node->id = $page->id;
            } else {
                $node->children[] = $this->buildPage($page, null);
            }
        }

        $children = $dossier->childs;
        foreach ($children as $child) {
            $tree = $this->buildTree($child);
            if ($tree !== null) {
                $node->children[] = $tree;
            }
        }

        $pagesDossiers = $dossier->miroirs()->where('statut_id', '=', Statut::PUBLIE)->get();
        foreach ($pagesDossiers as $pagesDossier) {
            $page = Page::published()
                ->where('id', '=', $pagesDossier->page_id)
                ->first();
            if ((int)$pagesDossier->page->statut_id === Statut::PUBLIE) {
                $node->children[] = $this->buildPage($page, $pagesDossier);
            }
        }

        return $node;
    }

    /**
     * @param \Traversable|Dossier[] $dossiers
     * @param int                    $level
     *
     * @return \Illuminate\Support\Collection
     */
    public function sortDossiers(\Traversable $dossiers, int $level): \Illuminate\Support\Collection
    {
        $tab = collect();

        foreach ($dossiers as $dossier) {
            $dossier->level = $level;
            $tab[] = $dossier;
            if ($dossier->childs) {
                $tab = $tab->concat($this->sortDossiers($dossier->childs, $level + 1));
            }
        }

        return $tab;
    }

    public function edit(Sante $sante)
    {
        $node = new Node();

        $pages = Page::published()->whereNull('dossier_id')->get();
        $tableDossiers = Dossier::query()->whereNull('parent_id')->get();

        foreach ($pages as $page) {
            $node->children[] = $this->buildPage($page, null);
        }
        foreach ($tableDossiers as $dossier) {
            $tree = $this->buildTree($dossier);
            if ($tree !== null) {
                $node->children[] = $tree;
            }
        }

        $dossiers = $this->sortDossiers($tableDossiers, 0);

        return view('Sante::admin.edit', compact('sante', 'node', 'dossiers'));
    }

    public function save(Sante $sante)
    {
        $user_id = Auth::user()->getAuthIdentifier();

        if (request('statut_id')) {
            $statut = request('statut_id');
        } else {
            if ($sante->page) {
                $statut = $sante->page->statut_id ?: Statut::EN_COURS;
            } else {
                $statut = Statut::EN_COURS;
            }
        }

        //Gestion du produit santé
        $sante->contenu = request('contenu');
        $sante->avantage = request('avantage');
        $sante->plus_rempart = request('plus_rempart');
        $sante->brochure = request('brochure');

        //Gestion des liens de la section Avantage
        for ($i = 1; $i <= 2; $i++) {
            $lien = 'avt_lien' . $i;
            $method = 'avantage' . $i;

            if (request('avt_lien' . $i) && request('link_choice_avt_lien' . $i)) {
                /**
                 * @var Lien $avt_lien
                 */
                $avt_lien = $sante->$lien != null ? $sante->$method : new Lien();
                $avt_lien->libelle = request('avt_lien' . $i . '_libelle');

                if (request('avt_lien' . $i . '_page_id')) {
                    $page_id = request('avt_lien' . $i . '_page_id');
                    $type = 'pages';
                    if ($page_id !== null) {
                        list($page_id, $type) = explode(';', $page_id);
                    }
                    if ($type === 'pages') {
                        $avt_lien->page_id = $page_id;
                        $avt_lien->miroir_id = null;
                    } else {
                        $avt_lien->miroir_id = $page_id;
                        $avt_lien->page_id = null;
                    }
                    $avt_lien->href = null;
                }

                if (request('avt_lien' . $i . '_href')) {
                    $parsed_link = parse_url(request('avt_lien' . $i . '_href'));
                    $avt_lien->href = empty($parsed_link['scheme']) ? 'http://' . request('avt_lien' . $i . '_href') : $avt_lien->href = request('avt_lien' . $i . '_href');
                    $avt_lien->page_id = null;
                }

                $avt_lien->save();

                if (!$sante->$method) $sante->$method()->associate($avt_lien);
            } else {
                if ($sante->$method) $sante->$method()->delete();
                $sante->$lien = null;
            }
        }

        //Gestion des liens de la section Plus Rempart

        for ($i = 1; $i <= 2; $i++) {
            $lien = 'plus_lien' . $i;
            $method = 'plus' . $i;

            if (request('plus_lien' . $i) && request('link_choice_plus_lien' . $i)) {
                /**
                 * @var Lien $plus_lien
                 */
                $plus_lien = $sante->$lien != null ? $sante->$method : new Lien();
                $plus_lien->libelle = request('plus_lien' . $i . '_libelle');

                if (request('plus_lien' . $i . '_page_id')) {
                    $page_id = request('plus_lien' . $i . '_page_id');
                    $type = 'pages';
                    if ($page_id !== null) {
                        list($page_id, $type) = explode(';', $page_id);
                    }
                    if ($type === 'pages') {
                        $plus_lien->page_id = $page_id;
                        $plus_lien->miroir_id = null;
                    } else {
                        $plus_lien->miroir_id = $page_id;
                        $plus_lien->page_id = null;
                    }
                    $plus_lien->href = null;
                }

                if (request('plus_lien' . $i . '_href')) {
                    $parsed_link = parse_url(request('plus_lien' . $i . '_href'));
                    $plus_lien->href = empty($parsed_link['scheme']) ? 'http://' . request('plus_lien' . $i . '_href') : $plus_lien->href = request('plus_lien' . $i . '_href');
                    $plus_lien->page_id = null;
                }

                $plus_lien->save();

                if (!$sante->$method) $sante->$method()->associate($plus_lien);
            } else {
                if ($sante->$method) $sante->$method()->delete();
                $sante->$lien = null;
            }
        }

        //Gestion des garanties

        //Garantie 1
        /**
         * @var Garantie $garantie
         * @var Exemple  $exemple
         */
        $garantie = $sante->exists ? $sante->garantie_1 : new Garantie();
        $garantie->intitule = request('garantie1_intitule');
        $garantie->details = request('garantie1_details');
        $garantie->save();

        if ($sante->exists) {
            $sante->garantie_1()->associate($garantie);
        } else {
            $sante->garantie1 = $garantie->id;
        }
        //Exemple de la garantie 1
        if (request('exemple1')) {
            $exemple = $garantie->exemple ?: new Exemple();
            $exemple->image = request('exemple1_image', '/images/vignette_default.png');
            $exemple->titre = request('exemple1_titre');
            $exemple->details = request('exemple1_details');
            $exemple->save();

            if (!$garantie->exemple) {
                $garantie->exemple()->associate($exemple);
            }

        } else {
            if ($garantie->exemple) $garantie->exemple()->delete();
            $garantie->exemple_id = null;
        }

        $garantie->save();


        //Autres garanties
        for ($i = 2; $i <= 5; $i++) {
            $gar = 'garantie' . $i;
            $method = 'garantie_' . $i;

            if (request('garantie' . $i)) {
                /**
                 * @var Garantie $garantie
                 * @var Exemple  $exemple
                 */
                $garantie = $sante->$gar != null ? $sante->$method : new Garantie();
                $garantie->intitule = request('garantie' . $i . '_intitule');
                $garantie->details = request('garantie' . $i . '_details');
                $garantie->save();

                if ($sante->$gar) {
                    $sante->$method()->associate($garantie);
                } else {
                    $sante->$gar = $garantie->id;
                }

                //Exemple des autres garanties
                if (request('exemple' . $i)) {
                    $exemple = $garantie->exemple ?: new Exemple();
                    $exemple->image = request('exemple' . $i . '_image', '/images/vignette_default.png');
                    $exemple->titre = request('exemple' . $i . '_titre');
                    $exemple->details = request('exemple' . $i . '_details');
                    $exemple->save();

                    if (!$garantie->exemple) $garantie->exemple()->associate($exemple);
                } else {
                    if ($garantie->exemple) $garantie->exemple()->delete();
                    $garantie->exemple_id = null;
                }

                $garantie->save();
            } else {
                if ($sante->$method && $sante->$method->exemple()) $sante->$method->exemple()->delete();
                if ($sante->$gar) $sante->$method()->delete();
                $sante->$gar = null;
            }
        }


        if (!$sante->exists) {
            // Nouveau

            //On crée le produit
            $sante->save();

            // On crée la page
            $page = new Page();
            $page->titre = request('titre');
            $page->slug = request('slug');
            $page->meta_titre = '';
            $page->meta_description = '';
            $page->created_by = $user_id;
            $page->last_modified_by = $user_id;
            $page->intro = request('intro');
            $page->dossier_id = request('dossier_id');
            $page->to_publish_at = request('date_pub');
            $page->to_unpublish_at = request('date_depub');
            $page->multiplicity = Page::SINGLE;
            $page->image_opengraph = request('vignette');

            if (request('date_pub') && Carbon::createFromFormat('Y-m-d', request('date_pub'))->isAfter(now())) {
                $statut = Statut::EN_COURS;
            }
            if (request('statut_id') == Statut::PUBLIE) {
                $statut = Statut::PUBLIE;
                $page->to_publish_at = now();
            }

            $page->statut_id = $statut;
            $page->contenu()->associate($sante);
            $page->save();

        } else {
            // Edition

            /**
             * @var Page $page
             */
            $page = $sante->page;

            if ($sante->isDirty()) {
                // On mets à jour la page
                $page->last_modified_by = $user_id;
                $sante->save();
            }
            $page->titre = request('titre');
            $page->slug = request('slug');
            $page->intro = request('intro');
            $page->dossier_id = request('dossier_id');
            $page->to_publish_at = request('date_pub');
            $page->to_unpublish_at = request('date_depub');
            $page->image_opengraph = request('vignette');


            if (request('date_pub') && Carbon::createFromFormat('Y-m-d', request('date_pub'))->isAfter(now())) {
                $statut = Statut::EN_COURS;
            }
            if (request('statut_id') == Statut::PUBLIE) {
                $statut = Statut::PUBLIE;
                $page->to_publish_at = now();
            }
            $page->statut_id = $statut;

            $page->image_opengraph = request('vignette');
            if ($page->isDirty()) {
                $page->last_modified_by = $user_id;
                $page->save();
            }
        }

        $sante->save();

        switch ($statut) {
            case Statut::EN_COURS:
                return redirect()->route('admin_sante_encours');

            case Statut::ARCHIVE:
                return redirect()->route('admin_sante_archived');

            default:
                return redirect()->route('admin_sante_index');
        }
    }

    public function preview(Sante $sante)
    {
        return $sante->getHandler()->single($sante);
    }

    public function archive(Sante $sante)
    {
        /**
         * @var Page $page
         */
        $page = $sante->page;
        $page->archive();

        return redirect()->back();
    }

    public function publish(Sante $sante)
    {
        /**
         * @var Page $page
         */
        $page = $sante->page;
        $page->publish();

        return redirect()->back();
    }

    public function unpublish(Sante $sante)
    {
        /**
         * @var Page $page
         */
        $page = $sante->page;
        $page->unpublish();

        return redirect()->back();
    }

    public function delete(Sante $sante)
    {
        /**
         * @var Page $page
         */
        $page = $sante->page;
        $page->softDelete();

        return redirect()->back();
    }

}
