<?php
/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

namespace Bloom\CMS\Modules\Sante;

use Bloom\CMS\Modules\Sante\Http\Middleware\ModuleMiddleware;
use Bloom\CMS\Modules\Architecture\Model\Module;
use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\Modules\Sante\Model\Sante;
use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Schema;

class CmsSanteServiceProvider extends \Illuminate\Support\ServiceProvider
{

    public function register(): void
    {
        $this->loadFactoriesFrom(dirname(__DIR__) . '/database/factories');
        $this->loadMigrationsFrom(dirname(__DIR__) . '/database/migrations');
        $this->loadViewsFrom(dirname(__DIR__) . '/resources/views', 'Sante');
        $dirname = dirname(__DIR__) . '/routes';
        foreach (scandir($dirname) as $file) {
            if (!in_array($file, ['.', '..'])) {
                Route::group(['middleware' => ['web', ModuleMiddleware::class]], function () use ($dirname, $file) {
                    $this->loadRoutesFrom($dirname . '/' . $file);
                });
            }
        }

        $this->publishes([
            dirname(__DIR__) . '/public/build' => public_path('/vendor/cms-module-sante')
        ], 'assets');
    }

    public static function getModule()
    {
        if (Schema::hasTable('modules')) {
            $module = Module::nom('sante')->firstOrNew([
                'nom'        => 'sante',
                'nom_public' => 'Produits de Santé',
                'route'      => 'admin_sante_index',
            ]);
            if(!$module->exists) {
                $module->active = 1;
                $module->save();
            }
            return $module;
        }

        return false;
    }

    public function boot(): void
    {

        // Déclaration contenu
        Relation::morphMap([
            'santes' => Sante::class,
        ]);
        Page::declareContenu('santes');
        self::getModule();
    }

}
