<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class ChangeRelationExemplesGaranties extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('produit_santes', function (Blueprint $table){
            $table->dropColumn('exemple1');
            $table->dropColumn('exemple2');
            $table->dropColumn('exemple3');
        });

        Schema::table('ps_garanties', function (Blueprint $table){
            $table->integer('exemple_id')->after('details');
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('produit_santes', function (Blueprint $table){
            $table->integer('exemple1');
            $table->integer('exemple2')->nullable();
            $table->integer('exemple3')->nullable();
        });

        Schema::table('ps_garanties', function (Blueprint $table){
            $table->dropColumn('exemple_id');
        });

    }
}
