<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProduitSantesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('produit_santes', function (Blueprint $table){
            $table->id();
            $table->unsignedInteger('page_id');
            $table->text('contenu');
            $table->text('avantage');
            $table->integer('avt_lien1')->nullable();
            $table->integer('avt_lien2')->nullable();
            $table->text('plus_rempart');
            $table->integer('plus_lien1')->nullable();
            $table->integer('plus_lien2')->nullable();
            $table->integer('garantie1');
            $table->integer('garantie2')->nullable();
            $table->integer('garantie3')->nullable();
            $table->integer('garantie4')->nullable();
            $table->integer('garantie5')->nullable();
            $table->string('brochure', 45);
            $table->integer('exemple1');
            $table->integer('exemple2')->nullable();
            $table->integer('exemple3')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('produit_santes');
    }
}
