<?php
/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

namespace Bloom\CMS\Modules\Sante;

use Bloom\CMS\Core\BloomProvider;
use Bloom\CMS\Core\Framework\Module;
use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\Modules\Sante\Model\Sante;
use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Schema;

class CmsSanteServiceProvider extends BloomProvider
{
    protected $nom = "Produits de Santé";
    protected $code = "sante";
    protected $has_admin = true;
    protected $icons = "heart";

    public function register(): void
    {
        $this->loadFactoriesFrom(dirname(__DIR__) . '/database/factories');
        $this->loadMigrationsFrom(dirname(__DIR__) . '/database/migrations');
        $this->loadViewsFrom(dirname(__DIR__) . '/resources/views', 'Sante');
        $dirname = dirname(__DIR__) . '/routes';
        foreach (scandir($dirname) as $file) {
            if (!in_array($file, ['.', '..'])) {
                $this->loadRoutesFrom($dirname . '/' . $file);
            }
        }

        $this->publishes([
            dirname(__DIR__) . '/public/build' => public_path('/vendor/cms-module-sante')
        ], 'assets');
    }

    protected function getModule(): ?\Bloom\CMS\Core\Framework\Module
    {
        if (Schema::hasTable('modules')) {
            $module = Module::nom('sante')->firstOrNew([
                'nom'        => 'sante',
                'nom_public' => 'Produits de Santé',
                'route'      => 'admin_sante_index',
            ]);
            if(!$module->exists) {
                $module->active = 1;
                $module->save();
            }
            return $module;
        }

        return false;
    }

    public function boot(): void
    {
        parent::boot();

        // Déclaration contenu
        Relation::morphMap([
            'santes' => Sante::class,
        ]);
        Page::declareContenu('santes');

        $this->getModule();
    }

}
