<?php
/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

use Illuminate\Support\Facades\Route;
use Bloom\CMS\Modules\Sante\Http\Controllers\AdminController;


Route::group(['prefix' => config('app.admin')], function () {
    Route::group(['prefix' => 'sante'], function () {
        Route::get('/', [AdminController::class,'index'])->name('admin_sante_index');
        Route::get('/encours', [AdminController::class,'encours'])->name('admin_sante_encours');
        Route::get('/archived', [AdminController::class,'archived'])->name('admin_sante_archived');
        Route::get('/edit/{sante?}', [AdminController::class,'edit'])->name('admin_sante_edit');
        Route::post('/edit/{sante?}', [AdminController::class,'save'])->name('admin_sante_save');
        Route::get('/{sante}/preview', [AdminController::class,'preview'])->name('admin_sante_preview');
        Route::get('/{sante}/publish', [AdminController::class,'publish'])->name('admin_sante_publish');
        Route::get('/{sante}/unpublish', [AdminController::class,'unpublish'])->name('admin_sante_unpublish');
        Route::get('/{sante}/archive', [AdminController::class,'archive'])->name('admin_sante_archive');
        Route::get('/{sante}/delete', [AdminController::class,'delete'])->name('admin_sante_delete');
    });
});
