<?php
/**
 * Created by : jérôme
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

namespace Bloom\CMS\Modules\Sante\Http\Controllers;


use Bloom\CMS\Modules\Architecture\Model\Lien;
use Bloom\CMS\Modules\Architecture\Model\Statut;
use Bloom\CMS\Modules\Sante\Model\Exemple;
use Bloom\CMS\Modules\Sante\Model\Garantie;
use Bloom\CMS\Modules\Sante\Model\Sante;
use Bloom\CMS\Modules\Architecture\Helpers\Actions;
use Bloom\CMS\Modules\Architecture\Model\Dossier;
use Bloom\CMS\Modules\Architecture\Model\Page;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Routing\Controller;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Auth;


class AdminController extends Controller
{

    public function getSubMenu(): array
    {
        return [
            'sub_menu_items' => [
                [
                    'title'  => 'Publiés',
                    'href'   => route('admin_sante_index'),
                    'number' => Sante::published()->count(),
                    'active' => request()->route()->getName() === 'admin_sante_index',
                ],
                [
                    'title'  => 'En cours de rédaction',
                    'href'   => route('admin_sante_encours'),
                    'number' => Sante::status(Statut::EN_COURS)->notProgrammed()->count(),
                    'active' => request()->route()->getName() === 'admin_sante_encours',
                ],
                [
                    'title'  => 'Archivés',
                    'href'   => route('admin_sante_archived'),
                    'number' => Sante::archived()->count(),
                    'active' => request()->route()->getName() === 'admin_sante_archived',
                ],
            ]
        ];
    }

    public function getViewData(array $data): array
    {
        return array_merge($data, $this->getSubMenu());
    }

    public function getDefaultActions(bool $with_sub = true): array
    {
        $actions = new Actions();
        $actions
            ->addAction('Modifier', 'admin_sante_edit')
            ->addNewTabAction('Prévisualiser', 'admin_sante_preview')
            ->addAction('Publier', 'admin_sante_publish');
        if ($with_sub) {
            $sub_actions = new Actions('sub_actions');
            $sub_actions
                ->addAction('Archiver', 'admin_sante_archive');
        }

        return array_merge($actions->toArray(), isset($sub_actions) ? $sub_actions->toArray() : []);
    }

    public function getSorted(Collection $collection)
    {
        $collection->load('page');
        $sort = function (Sante $sante) {
            return Arr::get(Arr::dot($sante->toArray()), request('orderBy', 'id'));
        };

        return [
            'santes' => request('order', 'asc') === "asc" ?
                $collection->sortBy($sort) :
                $collection->sortByDesc($sort),
            'order' => [
                'item'  => request('orderBy', 'id'),
                'order' => request('order', 'asc'),
            ]
        ];
    }

    public function index()
    {
        $actions = $this->getDefaultActions();

        // On remplace la 3ieme action du menu
        $actions['actions'][2] = [
            'name' => 'Dépublier', 'href' => 'admin_sante_unpublish'
        ];

        $data = array_merge($this->getSorted(Sante::published()->get()), $actions);

        return view('Sante::admin.listing', $this->getViewData($data));
    }

    public function encours()
    {
        $data = array_merge($this->getSorted(Sante::status(2)->notProgrammed()->get()), $this->getDefaultActions());

        return view('Sante::admin.listing', $this->getViewData($data));
    }

    public function archived()
    {
        $data = array_merge(
            $this->getSorted(Sante::archived()->get()),
            (new Actions())
                ->addAction('Prévisualiser', 'admin_sante_preview')
                ->addAction('Désarchiver', 'admin_sante_unpublish')->toArray()
        );

        return view('Sante::admin.listing', $this->getViewData($data));
    }

    public function edit(Sante $sante)
    {
        $pages = Page::published()->get();

        return view('Sante::admin.edit', compact('sante', 'pages'));
    }

    public function save(Sante $sante)
    {
        $user_id = Auth::user()->getAuthIdentifier();

        if (request('statut_id')) {
            $statut = request('statut_id');
        } else {
            if ($sante->page) {
                $statut = $sante->page->statut_id ?: Statut::EN_COURS;
            } else {
                $statut = Statut::EN_COURS;
            }
        }

        //Gestion du produit santé
        $sante->contenu = request('contenu');
        $sante->avantage = request('avantage');
        $sante->plus_rempart = request('plus_rempart');
        $sante->brochure = request('brochure');

        //Gestion des liens de la section Avantage
        for ($i=1; $i<=2; $i++) {
            $lien = 'avt_lien'.$i;
            $method = 'avantage'.$i;

            if (request('avt_lien'.$i) && request('link_choice_avt_lien'.$i)) {
                /**
                 * @var Lien $avt_lien
                 */
                $avt_lien = $sante->$lien != null ? $sante->$method : new Lien();
                $avt_lien->libelle = request('avt_lien'.$i.'_libelle');

                if (request('avt_lien'.$i.'_page_id')) {
                    $avt_lien->page_id = request('avt_lien'.$i.'_page_id');
                    $avt_lien->href = null;
                }

                if (request('avt_lien'.$i.'_href')) {
                    $parsed_link = parse_url(request('avt_lien'.$i.'_href'));
                    $avt_lien->href = empty($parsed_link['scheme']) ? 'http://' . request('avt_lien'.$i.'_href') : $avt_lien->href = request('avt_lien'.$i.'_href');
                    $avt_lien->page_id = null;
                }

                if($sante->$lien != null) $sante->$method()->associate($avt_lien);
                $avt_lien->save();
            }
            else {
                $sante->$lien = null;
            }
        }

        //Gestion des liens de la section Plus Rempart
        for ($i=1; $i<=2; $i++) {
            $lien = 'plus_lien'.$i;
            $method = 'plus'.$i;

            if (request('plus_lien'.$i) && request('link_choice_plus_lien'.$i)) {
                /**
                 * @var Lien $plus_lien
                 */
                $plus_lien = $sante->$lien != null ? $sante->$method : new Lien();
                $plus_lien->libelle = request('plus_lien'.$i.'_libelle');

                if (request('plus_lien'.$i.'_page_id')) {
                    $plus_lien->page_id = request('plus_lien'.$i.'_page_id');
                    $plus_lien->href = null;
                }

                if (request('plus_lien'.$i.'_href')) {
                    $parsed_link = parse_url(request('plus_lien'.$i.'_href'));
                    $plus_lien->href = empty($parsed_link['scheme']) ? 'http://' . request('plus_lien'.$i.'_href') : $plus_lien->href = request('plus_lien'.$i.'_href');
                    $plus_lien->page_id = null;
                }
                if ($sante->$lien != null) $sante->$method()->associate($plus_lien);
                $plus_lien->save();
            }
            else {
                $sante->$lien = null;
            }
        }

        //Gestion des garanties

        //Garantie 1
        /**
         * @var Garantie $garantie
         * @var Exemple $exemple
         */
        $garantie = $sante->exists ? $sante->garantie_1 : new Garantie();
        $garantie->intitule = request('garantie1_intitule');
        $garantie->details = request('garantie1_details');
        $sante->exists ? $sante->garantie_1()->associate($garantie) : $garantie->save();
        $garantie->save();

        //Exemple de la garantie 1
        $exemple = $sante->exists ? $garantie->exemple : new Exemple();
        $exemple->image = request('exemple1_image');
        $exemple->titre = request('exemple1_titre');
        $exemple->details = request('exemple1_details');

        $sante->exists ? $garantie->exemple()->associate($garantie) : $garantie->save();


        //Autres garanties
        for ($i=2; $i<=5; $i++) {
            $gar = 'garantie'.$i;
            $method = 'garantie_'.$i;

            if (request('exemple'.$i) && request('garantie'.$i)) {
                /**
                 * @var Garantie $garantie
                 * @var Exemple $exemple
                 */
                $garantie = $sante->$gar != null ? $sante->$method : new Garantie();
                $garantie->intitule = request('garantie'.$i.'_intitule');
                $garantie->details = request('garantie'.$i.'_details');
                $garantie->save();

                //Exemple des autres ganaties
                $exemple = $sante->$gar != null ? $garantie->exemple : new Exemple();
                $exemple->image = request('exemple'.$i.'_image');
                $exemple->titre = request('exemple'.$i.'_titre');
                $exemple->details = request('exemple'.$i.'_details');

                $exemple->save();
                $sante->$gar != null ? $garantie->exemple()->associate($garantie) : $garantie->save();
            }
            else {
                $sante->$gar = null;
            }
        }



        if (!$sante->exists) {
            // Nouveau

            // On crée la page
            $page = new Page();
            $page->titre = request('titre');
            $page->slug = request('slug');
            $page->meta_titre = '';
            $page->meta_description = '';
            $page->created_by = $user_id;
            $page->last_modified_by = $user_id;
            $page->intro = request('intro');
            $page->to_publish_at = request('date_pub');
            $page->to_unpublish_at = request('date_depub');
            $page->multiplicity = Page::SINGLE;
            $page->image_opengraph = request('vignette');

            if (request('date_pub') && Carbon::createFromFormat('Y-m-d', request('date_pub'))->isAfter(now())) {
                $statut = 2;
            }
            if (request('statut_id') == 1) {
                $statut = 1;
                $page->to_publish_at = now();
            }

            $page->statut_id = $statut;
            $page->contenu()->associate($sante);
            $page->save();

        } else {
            // Edition

            /**
             * @var Page $page
             */
            $page = $sante->page;

            if ($sante->isDirty()) {
                // On mets à jour la page
                $page->last_modified_by = $user_id;
                $sante->save();
            }
            $page->titre = request('titre');
            $page->slug = request('slug');
            $page->intro = request('intro');
            $page->to_publish_at = request('date_pub');
            $page->to_unpublish_at = request('date_depub');
            $page->image_opengraph = request('vignette');



            if (request('date_pub') && Carbon::createFromFormat('Y-m-d', request('date_pub'))->isAfter(now())) {
                $statut = Statut::EN_COURS;
            }
            if (request('statut_id') == Statut::PUBLIE) {
                $statut = Statut::PUBLIE;
                $page->to_publish_at = now();
            }
            $page->statut_id = $statut;

            $page->image_opengraph = request('vignette');
            if ($page->isDirty()) {
                $page->last_modified_by = $user_id;
                $page->save();
            }
        }

        $sante->save();

        switch ($statut) {
            case Statut::EN_COURS:
                return redirect()->route('admin_sante_encours');

            case Statut::ARCHIVE:
                return redirect()->route('admin_sante_archived');

            default:
                return redirect()->route('admin_sante_index');
        }
    }

    public function preview(Sante $sante)
    {
        return $sante->getHandler()->single($sante);
    }

    public function archive(Sante $sante)
    {
        /**
         * @var Page $page
         */
        $page = $sante->page;
        $page->archive();

        return redirect()->back();
    }

    public function publish(Sante $sante)
    {
        /**
         * @var Page $page
         */
        $page = $sante->page;
        $page->publish();

        return redirect()->back();
    }

    public function unpublish(Sante $sante)
    {
        /**
         * @var Page $page
         */
        $page = $sante->page;
        $page->unpublish();

        return redirect()->back();
    }

    public function delete(Sante $sante)
    {
        /**
         * @var Page $page
         */
        $page = $sante->page;
        $page->softDelete();

        return redirect()->back();
    }

}