const slugify = require('slugify');

let form;
window.publishAndSubmit = () => {
    form = $('.main form');
    // Si le form est pas présent c'est que jean michel click avant la fin du chargement de la page
    if (form === undefined) {
        document.addEventListener('readystatechange', publishAndSubmit);
    }

    let statut = form.find('input[name="statut_id"]').first();

    if (statut.length) {
        statut.val('1');
    } else {
        form.append($('<input name="statut_id" value="1" type="hidden">'));
    }

    form.submit();
}


document.addEventListener("readystatechange", () => {
    /**
     * Block / Unblock link_choice
     * @param {boolean} state
     */

    function lienChange(state, el = null) {
        let section = el.attr('name').split('lien')[1];

        $('[name="link_choice' + section + '"]').prop("disabled", !state);
        $('.wrapper' + section).show();
        if (!state) {
            $('[name="link_choice' + section + '"]').prop("checked", false);
            $('[name="href' + section + '"]').val('');
            $('[name="page_id' + section + '"]').val('');
            $('.wrapper' + section).hide();
        }
        $('[name="link_choice' + section + '"]').each(function() {
            let $el = $(this);
            switch ($el.val()) {
                case 'interne':
                    $('[id="page_id' + section + '"]').prop('disabled', !$el.is(':checked'));
                    break;
                case 'externe':
                    $('[id="href' + section + '"]').prop('disabled', !$el.is(':checked'));
            }
        });
    }

    function niveauChange(state, el = null) {
        let section = el.attr('name').split('niveau')[1];
        $('.wrapper' + section).show();

        if (!state) {
            $('.wrapper' + section).hide();
            $('.wrapper' + section + ' input').val('');
            $('.wrapper' + section + ' textarea').val('');
            if (CKEDITOR.instances['details' + section] != undefined) {
                CKEDITOR.instances['details' + section].setData('');
            }
        }
    }

    function exempleChange(state, el = null) {
        let section = el.attr('name').split('example')[1];
        $('.wrapper' + section).show();

        if (!state) {
            $('.wrapper' + section).hide();
            $('.wrapper' + section + ' input').val('');
            $('.wrapper' + section + ' textarea').val('');
            if (CKEDITOR.instances['details' + section] != undefined) {
                CKEDITOR.instances['details' + section].setData('');
            }
        }
    }

    form = $('.main form');
    let liens = $('input[name^="lien"]'),
        niveaux = $('input[name^="niveau"]'),
        exemples = $('input[name^="example"]');

    if (liens.length) {
        for (let i = liens.length - 1; i >= 0; i--) {
            let section = liens[i].name.split('lien')[1];
            $('.wrapper' + section).hide();
            $(liens[i]).change(function (e) {
                lienChange($(e.target).is(':checked'), $(e.target));
            });
            lienChange($(liens[i]).is(':checked'), $(liens[i]));
            $('[name="link_choice' + section + '"]').change(function(e) {
                let choice = e.currentTarget.value;

                if (choice.toLowerCase() == 'interne') {
                    $('[name="page_id' + section + '"]').prop('disabled', false);
                    $('[name="href' + section + '"]').prop('disabled', true);
                    $('[name="href' + section + '"]').val('');
                }

                if (choice.toLowerCase() == 'externe') {
                    $('[name="page_id' + section + '"]').prop('disabled', true);
                    $('[name="page_id' + section + '"]').val('');
                    $('[name="href' + section + '"]').prop('disabled', false);
                }
            });
        }
    }

    if (niveaux.length) {
        for (let i = niveaux.length - 1; i >= 0; i--) {
            let section = niveaux[i].name.split('niveau')[1];
            $('.wrapper' + section).hide();
            $(niveaux[i]).change(function (e) {
                niveauChange($(e.target).is(':checked'), $(e.target));
            });
            niveauChange($(niveaux[i]).is(':checked'), $(niveaux[i]));
        }
    }

    if (exemples.length) {
        for (let i = exemples.length - 1; i >= 0; i--) {
            let section = exemples[i].name.split('example')[1];
            $('.wrapper' + section).hide();
            $(exemples[i]).change(function (e) {
                exempleChange($(e.target).is(':checked'), $(e.target));
            });
            exempleChange($(exemples[i]).is(':checked'), $(exemples[i]));
        }
    }

    $('#titre').on('input', function (e) {
        $('#slug').val(slugify(e.target.value, {strict: true, remove: /\s[!.?]/g}))
    });
    
});



    // function switchChange(state) {
    //     let name = $(this).attr('name');
    //     let inputs = $(this).children('input[name^='+ name +']');
    //     let textarea = $(this).children('textarea[name^='+ name +']');
    //
    //     inputs.each(() => {
    //         $(this).prop('disabled', state);
    //     });
    //     textarea.prop('disabled', state);
    //
    // }
    //
    // form = $('.main form');
    // let garanties = $('[type="checkbox"][name^="garantie"]');
    // let exemples = $('input[name^="exemple"]');
    //
    // garanties.each( () => {
    //     switchChange($(this).is(':checked'));
    // });
    //
    // exemples.each( () => {
    //     switchChange($(this).is(':checked'));
    // });
    //
    // if (garanties.length) {
    //     garanties.each( () => {
    //         $(this).change((e) => {
    //             switchChange($(e.target).is(':checked'));
    //         })
    //     })
    // }
    //