<?php
/**
 * Created by : Jérôme
 * Created at : 07/01/2021
 *
 * In : PhpStorm
 */

namespace Bloom\CMS\Modules\Recrutement\Http\Controllers;


use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\Modules\Recrutement\Model\File;
use Bloom\CMS\Modules\Recrutement\Model\LeadRecrutement;
use Bloom\CMS\Modules\Recrutement\Model\Recrutement;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\UploadedFile;
use Illuminate\Routing\Controller;
use SebastianBergmann\Type\ObjectType;


class FrontController extends Controller
{
    public function index(Page $page)
    {
        /**
         * @var Collection $recrutements
         */
        $recrutements = Recrutement::published()->join('pages', function ($join) {
            $join->on('recrutements.id', '=', 'pages.contenu_id')
                ->where('pages.contenu_type', '=', 'recrutements');
        })
            ->latest('pages.updated_at')->paginate(3);

        $spontanee = Recrutement::find(0);

        $breadcrumbElements = [["name" => 'Annonces', 'url' => '']];
        $dossier = $page->dossier;
        while ($dossier !== null) {
            $breadcrumbElements[] = ['name' => $dossier->name, 'url' => $dossier->full_pathname];
            $dossier = $dossier->parent;
        }

        $breadcrumbElements = array_reverse($breadcrumbElements);

        return view('Recrutement::front.listing', compact('recrutements', 'breadcrumbElements', 'page', 'spontanee'));
    }

    /**
     * @param Request $request
     * @return RedirectResponse | JsonResponse
     */
    public function saveLead(Request $request)
    {
        //Contrôle des formats des fichiers
        $format = false;
        foreach ($request->allFiles() as $upload) {
            /**
             * @var UploadedFile $upload
             */
            $format = array_search($upload->getClientOriginalExtension(), ['pdf', 'doc', 'docx', 'odt']) !== false;
        }

        if($format) {
            $lead = LeadRecrutement::withoutEvents(function() use ($request) {
                $lead = new LeadRecrutement();
                $lead->civilite = $request->civ;
                $lead->nom = $request->nom;
                $lead->prenom = $request->prenom;
                $lead->telephone = $request->tel;
                $lead->email = $request->email;
                $lead->recrutement_id = $request->recrutement_id;
                $lead->provenance_url = $request->headers->get('referer');
                $lead->ip = $request->ip();
                $lead->save();
                return $lead;
                });

            foreach ($request->allFiles() as $upload) {
                /**
                 * @var UploadedFile $upload
                 */
                $file = new File();
                $file->libelle = $upload->getClientOriginalName();
                $file->file = $upload->storeAs(
                    'leadFile',
                    hash_file('sha1', $upload->getRealPath()) . '.' . $upload->getClientOriginalExtension(),
                    'public'
                );
                $file->lead_id = $lead->id;
                $file->save();
            }


            event('eloquent.created: '.LeadRecrutement::class, $lead);
            return redirect()->back()->withInput(['success' => 'Votre candidature a bien été envoyée.']);
        } else {
            return redirect()->back()->withErrors(['error' => 'Format de fichier interdit'], 403);
        }
    }
}