<?php

/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

namespace Bloom\CMS\Modules\Recrutement;

use Bloom\CMS\Core\BloomProvider;
use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\Modules\Recrutement\Model\Recrutement;
use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Support\Facades\Schema;

class CmsRecrutementServiceProvider extends BloomProvider
{
    protected $nom = "Recrutement";
    protected $code = "recrutement";
    protected $icons = "briefcase";

    public function boot(): void
    {
        parent::boot();

        if (Schema::hasTable('page_statiques')) {
            (new \PageAnnoncesSeeder)->run();
        }

        // Déclaration contenu
        Relation::morphMap([
            'recrutements' => Recrutement::class,
        ]);
        Page::declareContenu('recrutements');
    }
}
