<?php

/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

namespace Bloom\CMS\Modules\Recrutement\Http\Controllers;

use Bloom\CMS\Core\Contenus\Statut;
use Bloom\CMS\Core\Helpers\Actions;
use Bloom\CMS\Core\Helpers\Workflow;
use Bloom\CMS\Core\Http\Dossier;
use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\HPV\Cliniques\Model\Clinique;
use Bloom\CMS\Modules\Recrutement\Model\Recrutement;
use Bloom\CMS\Modules\Recrutement\Model\Service;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Routing\Controller;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Auth;

/**
 * Class AdminController
 *
 * @package Bloom\CMS\Modules\Recrutement\Http\Controllers
 */
class AdminController extends Controller
{
    public function edit(Recrutement $recrutement)
    {
        $cliniques = Clinique::all();
        $services = Service::all();//A modifier quand la relation sera créé sur le module clinique
        $dossiers = Dossier::all();
        $page = $recrutement->page;
        if (request('dossier_id')) {
            if ($page === null) {
                $page = new Page();
            }
            $page->dossier_id = request('dossier_id');
        }

        return view('Recrutement::admin.edit', compact('recrutement', 'dossiers', 'page', 'cliniques', 'services'));
    }

    /**
     * Permet de fill les parametre générique d'une page avec le formulaire
     *
     * @param Page $page
     */
    protected function fillPage(Page $page): void
    {
        $page->titre = request('titre');
        $page->intro = request('description'); // pas d'intro dans les annonces donc on reprend la description comme indiqué dans le brief
        $page->slug = request('slug');
        $page->image_opengraph = request('vignette');
        $page->mentions = request('mentions');
        $page->updatePathname();
    }

    /**
     * Crée le recrutement et sa page en valorisant correctement le statut, celui-ci pouvant être surchargé en fonction
     * des valeurs du formulaire
     *
     * @param Recrutement $recrutement
     * @param int     $statut
     *
     * @return int
     */
    public function createRecrutement(Recrutement $recrutement, int $statut): int
    {
        // On crée le recrutement
        $recrutement->contenu = request('description');
        $recrutement->save();
        $recrutement->reference .= $recrutement->id;
        $recrutement->save();

        /**
         * @var Dossier $dossier
         */
        $dossier = Dossier::where('name', '=', 'Annonces')->first();

        // On crée la page
        $page = new Page();
        $page->meta_titre = '';
        $page->meta_description = '';
        $page->created_by = Auth::user()->getAuthIdentifier();
        $page->last_modified_by = Auth::user()->getAuthIdentifier();
        $page->multiplicity = Page::SINGLE;
        $page->dossier_id = $dossier->id; //Toutes les annonces sont dans le dossier Annonces pour gérer les redirections.
        $this->fillPage($page);
        $page->to_publish_at = now();
        $page->statut_id = $statut;



        // On attache la page et le recrutement
        $page->contenu()->associate($recrutement);
        $page->save();

        return $statut;
    }

    /**
     * Modifie le recrutement et sa page en valorisant correctement le statut, celui-ci pouvant être surchargé en fonction
     * des valeurs du formulaires
     *
     * @param Recrutement $recrutement
     * @param int     $statut
     *
     * @return int
     */
    public function editRecrutement(Recrutement $recrutement, int $statut): int
    {
        /**
         * @var Page $page
         */
        $page = $recrutement->page;

        $recrutement->contenu = request('description');

        if ($recrutement->isDirty()) {
            // On mets à jour la page
            $page->last_modified_by = Auth::user()->getAuthIdentifier();
            $recrutement->save();
            $page->touch();
        }

        $this->fillPage($page);

        $page->statut_id = $statut;

        if ($page->isDirty()) {
            $page->last_modified_by = Auth::user()->getAuthIdentifier();
            $page->save();
            $recrutement->touch();
        }

        return $statut;
    }

    public function save(Recrutement $recrutement)
    {
        $recrutement->clinique_id = request('lieu');
        $recrutement->service_id = request('service');
        $recrutement->contrat_type = request('contrat_type');
        $recrutement->date_embauche = request('date-embauche');
        $recrutement->duree = request('duree');

        // Création de la référence de l'annonce
        if (!$recrutement->exists) {
            $clinique = Clinique::findOrFail(request('lieu'));
            $service = Service::findOrFail(request('service'));
            $recrutement->reference = '#hpv' . substr(strtolower($clinique->nom),0,3) . substr(strtolower($service->nom),0,3);
        }

        $statut = 1;

        if ($recrutement->page !== null) {
            $statut = $recrutement->page->statut_id ?: 1;
        }
        $statut = $recrutement->exists ? $this->editRecrutement($recrutement, $statut) : $this->createRecrutement($recrutement, $statut);

        if ($statut == 0) {
            $workflow = Workflow::query()->where('code', '=', 'RECRUTEMENT_ARCHIVED')->first();

            return redirect()->route('admin_clinique_index', $workflow);
        }

        return redirect()->route('admin_recrutement_index');
    }

    public function preview(Recrutement $recrutement)
    {
        return $recrutement->getHandler()->single($recrutement);
    }

    public function archive(Recrutement $recrutement)
    {
        /**
         * @var Page $page
         */
        $page = $recrutement->page;
        $page->archive();

        return redirect()->back();
    }

    public function publish(Recrutement $recrutement)
    {
        /**
         * @var Page $page
         */
        $page = $recrutement->page;
        $page->publish();

        return redirect()->back();
    }

    public function unpublish(Recrutement $recrutement)
    {
        /**
         * @var Page $page
         */
        $page = $recrutement->page;
        $page->unpublish();

        return redirect()->back();
    }

    public function duplicate(Recrutement $recrutement)
    {
        /**
         * @var Page $page
         */
        $page = $recrutement->page;
        $page2 = $page->replicate();
        $page2->titre .= ' - Copie';
        $page2->slug .= '-copie';
        $page2->pathname .= '-copie';
        // L’entité dupliquée prend le statut ‘en cours’
        $page2->statut_id = 2;
        $page2->to_publish_at = null;
        $page2->to_unpublish_at = null;
        $page2->save();

        $article2 = $recrutement->replicate();
        $article2->save();
        $page2->contenu()->associate($article2);
        $page2->save();
        // Ouverture de l’onglet/workflow ‘en cours’
        $workflow = Workflow::query()->where('code', '=', 'RECRUTEMENT_EN_COURS')->first();

        return redirect()->route('admin_recrutement_index', $workflow);
    }

    public function delete(Recrutement $recrutement)
    {
        /**
         * @var Page $page
         */
        $page = $recrutement->page;
        $page->softDelete();

        return redirect()->back();
    }
}
