<?php

/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

namespace Bloom\CMS\Modules\Recrutement;

use Bloom\CMS\Core\BloomProvider;
use Bloom\CMS\Core\Contenus\Statut;
use Bloom\CMS\Core\Helpers\Actions;
use Bloom\CMS\Core\Helpers\TableHeader;
use Bloom\CMS\Core\Helpers\WorkflowsFactory;
use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\Modules\Recrutement\Model\Recrutement;
use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Support\Facades\Schema;

class CmsRecrutementServiceProvider extends BloomProvider
{
    protected $nom = "Recrutement";
    protected $code = "recrutement";
    protected $icons = "briefcase";

    public function boot(): void
    {
        parent::boot();

        if (Schema::hasTable('page_statiques')) {
            (new \PageAnnoncesSeeder)->run();
        }

        // Déclaration contenu
        Relation::morphMap([
            'recrutements' => Recrutement::class,
        ]);
        Page::declareContenu('recrutements');
        $factory = new WorkflowsFactory(Recrutement::class);
        $this->declarePublishedWorkflow($factory);
        $this->declareEnCoursWorkflow($factory);
        $this->declareArchivedWorkflow($factory);
        $this->haveGenericIndex($factory);
    }

    public function declarePublishedWorkflow(WorkflowsFactory $factory)
    {
        $factory
            //#region RECRUTEMENT_PUB
            ->add('Publiés', "RECRUTEMENT_PUB")
            ->statement('select r.*
                                from recrutements as r
                                inner Join pages on r.id = pages.contenu_id and pages.contenu_type = "recrutements"
                                where pages.statut_id = ' . Statut::PUBLIE . '
                                order by r.updated_at DESC')
            ->edition('admin_recrutement_edit', 'Créer une annonce')
            ->setAction(
                (new Actions())
                    ->addAction('Modifier', 'admin_recrutement_edit')
                    ->addNewTabAction('Prévisualiser', 'admin_recrutement_preview')
            )->setSubActions(
                (new Actions())
                    ->addAction('Dupliquer', 'admin_recrutement_duplicate', 'bloomicon-admin-copy')
                    ->addAction('Dépublier', 'admin_recrutement_unpublish', 'bloomicon-admin-arrow-down-left')
                    ->addAction('Archiver', 'admin_recrutement_archive', 'bloomicon-admin-archive')
            )->setHeaders(
                [
                    (new TableHeader('Vignette', 'page.image_opengraph'))->isImage(),
                    (new TableHeader('Id', 'id'))->canOrder(),
                    (new TableHeader('Nom', 'page.titre'))->canOrder(),
                    (new TableHeader('Clinique', 'clinique.nom'))->canOrder(),
                    (new TableHeader('Créé le', 'created_at'))->canOrder()->haveTitle('page.cree_par.name'),
                    (new TableHeader('Modifié le', 'updated_at'))
                        ->canOrder()->haveTitle('page.derniere_modification_par.name'),
                    (new TableHeader('Dates de<br> publication', 'page.to_publish_at'))->canOrder(),
                ]
            )
            ->push();
        //#endregion
    }

    public function declareEnCoursWorkflow(WorkflowsFactory $factory)
    {
        $factory
            //#region RECRUTEMENT_EN_COURS
            ->add('En cours de rédaction', "RECRUTEMENT_EN_COURS")
            ->statement('select r.*
                                from recrutements as r
                                inner Join pages on r.id = pages.contenu_id and pages.contenu_type = "recrutements"
                                where pages.statut_id = ' . Statut::EN_COURS . '
                                order by r.updated_at DESC')
            ->edition('admin_recrutement_edit', 'Créer une annonce')
            ->setAction(
                (new Actions())
                    ->addAction('Modifier', 'admin_recrutement_edit')
                    ->addNewTabAction('Prévisualiser', 'admin_recrutement_preview')
            )->setSubActions(
                (new Actions())
                    ->addAction('Dupliquer', 'admin_recrutement_duplicate', 'bloomicon-admin-copy')
                    ->addAction('Publier', 'admin_recrutement_publish', 'bloomicon-admin-arrow-up-right')
                    ->addAction('Archiver', 'admin_recrutement_archive', 'bloomicon-admin-archive')
            )->setHeaders(
                [
                    (new TableHeader('Vignette', 'page.image_opengraph'))->isImage(),
                    (new TableHeader('Id', 'id'))->canOrder(),
                    (new TableHeader('Nom', 'page.titre'))->canOrder(),
                    (new TableHeader('Clinique', 'clinique.nom'))->canOrder(),
                    (new TableHeader('Créé le', 'created_at'))->canOrder()->haveTitle('page.cree_par.name'),
                    (new TableHeader('Modifié le', 'updated_at'))
                        ->canOrder()->haveTitle('page.derniere_modification_par.name'),
                    (new TableHeader('Dates de<br> publication', 'page.to_publish_at'))->canOrder(),
                ]
            )
            ->push();
        //#endregion
    }

    public function declareArchivedWorkflow($factory)
    {
        $factory
            //#region RECRUTEMENT_ARCHIVED
            ->add('Archivés', "RECRUTEMENT_ARCHIVED")
            ->statement('select r.*
                                from recrutements as r
                                inner Join pages on r.id = pages.contenu_id and pages.contenu_type = "recrutements"
                                where pages.statut_id = ' . Statut::ARCHIVE . '
                                order by r.updated_at DESC')
            ->edition('admin_recrutement_edit', 'Créer une annonce')
            ->setAction(
                (new Actions())
                    ->addAction('Désarchiver', 'admin_recrutement_unpublish')
                    ->addAction('Supprimer', 'admin_recrutement_delete')
            )->setSubActions(
                (new Actions())
                    ->addAction('Dupliquer', 'admin_recrutement_duplicate', 'bloomicon-admin-copy')
            )->setHeaders(
                [
                    (new TableHeader('Vignette', 'page.image_opengraph'))->isImage(),
                    (new TableHeader('Id', 'id'))->canOrder(),
                    (new TableHeader('Nom', 'page.titre'))->canOrder(),
                    (new TableHeader('Clinique', 'clinique.nom'))->canOrder(),
                    (new TableHeader('Créé le', 'created_at'))->canOrder()->haveTitle('page.cree_par.name'),
                    (new TableHeader('Modifié le', 'updated_at'))
                        ->canOrder()->haveTitle('page.derniere_modification_par.name'),
                    (new TableHeader('Dates de<br> publication', 'page.to_publish_at'))->canOrder(),
                ]
            )
            ->push();
        //#endregion
    }
}
