import recrutements from './recrutements.vue';

const Vue = require('vue');

document.addEventListener("DOMContentLoaded", () => {
    new Vue({
        el: '#wrapper-listing-recrutement',
        components: { 'recrutements' : recrutements },
        data() {
            return {
                recrutements: [],
                loadData: true,
                page: 2,
                scrollY: 0
            };
        },
        updated() {
            document.documentElement.scrollTop = document.body.scrollTop = this.scrollY;
        },
        methods: {
            loadNext() {
                this.scrollCalc();
                let loader = document.getElementById('loader-general');
                if (loader != undefined) {
                    loader.style.display = 'block';
                }
                $.ajax({
                    url: '/recrutement/maj/' + this.page,
                    type: 'GET',
                    success: (response) => {
                        this.recrutements = this.recrutements.concat(response.data);
                        this.page++;
                        this.loadData = (response.total !== response.to);
                    }
                }).then(() => {
                    if (loader != undefined) {
                        loader.style.display = 'none';
                    }
                });
            },
            scrollCalc() {
                this.scrollY = window.scrollY;
            }
        }
    });
});