<?php

use Bloom\CMS\Core\Contenus\Statut;
use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\Modules\Recrutement\Model\Recrutement;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class PageAnnoncesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        //#region Annonces
        if (!DB::table('dossiers')
        ->where('name', '=', 'Annonces')->exists()) {
            $dossier_id = DB::table('dossiers')->insertGetId([
                'name' => 'Annonces',
                'slug' => 'annonces',
                'type' => 'simple',
            ]);
        }
        else {
            $dossier_id = DB::table('dossiers')->where('name', '=', 'Annonces')->value('id');
        }

        if (!DB::table('page_statiques')
            ->where('controller', 'Bloom\CMS\Modules\Recrutement\Http\Controllers\FrontController@index')->exists()) {
            $id = DB::table('page_statiques')->insertGetId([
                'controller'   => 'Bloom\CMS\Modules\Recrutement\Http\Controllers\FrontController@index',
                'display_type' => 'Recrutements',
                'action' => 'Gérer les annonces de recrutement',
                'route' => 'admin_recrutement_index'
            ]);
            $page = new Page();
            $page->titre = 'Recrutement';
            $page->meta_titre = 'Recrutement';
            $page->meta_description = 'Recrutement';
            $page->slug = '';
            $page->pathname = '';
            $page->intro = "<p>Ceci est l'intro de la page recrutement</p>";
            $page->mentions = "<p>Ici les mentions légales de la page de recrutement</p>";
            $page->multiplicity = '1';
            $page->to_publish_at = now();
            $page->statut_id = Statut::PUBLIE;
            $page->created_by = 1;
            $page->last_modified_by = 1;
            $page->image_opengraph = null;
            $page->contenu_type = 'page_statiques';
            $page->contenu_id = $id;
            $page->dossier_id = $dossier_id;
            $page->is_index = 1;
            $page->save();
        }
        //#endregion

        //#region Candidature Spontanée
        if(!Recrutement::where('id','=', 0)->exists()){
            DB::table('recrutements')->insert([
                'contenu' => '<p>Ceci est le contenu de la candidature spontanée</p>',
                'clinique_id' => 0,
                'service_id' => 0,
                'contrat_type' => 'Spontanée',
                'reference' => '#hpvspon0'
            ]);
            $recrutement = Recrutement::where('contrat_type', '=', 'Spontanée')->first();
            $recrutement->id = 0;
            $recrutement->save();
        }
        //#endregion
    }
}
