<?php

/**
 * Created by : Jérôme Bonnier
 * Created at : 23/12/2020
 *
 * In : PhpStorm
 */

namespace Bloom\CMS\Modules\Recrutement\Model;


use Bloom\Cms\Modules\Leads\Model\Lead;
use Bloom\Cms\Notification\Data\Services;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;

/**
 * Class LeadRecrutement
 *
 * @package Bloom\CMS\Modules\Recrutement\Model
 *
 * @property integer id
 * @property string  civilite
 * @property string  nom
 * @property string  prenom
 * @property string  telephone
 * @property string  email
 * @property integer recrutement_id
 * @property string  provenance_url
 * @property string  ip
 *
 */
class LeadRecrutement extends Lead
{

    protected $table = 'contacts_recrutement';
    protected $should_notify = true;
    protected $with = ['files', 'recrutement'];


    public function files()
    {
        return $this->hasMany(File::class, 'lead_id');
    }

    public function recrutement()
    {
        return $this->belongsTo(Recrutement::class);
    }

    /**
     * @inheritDoc
     */
    public function sendNotififcation(): void
    {
        try {
            $data = $this->toArray();

            $files = $this->files->toArray();

            $annonce = $this->recrutement;
            $page = $annonce->page;

            $data['files'] = $files;
            $data['annonce'] = $annonce->toArray();

//            dd($data, $files);


            $prefix = in_array(config('app.env'), ['dev', 'local', 'developpement']) ? '[ENV]' : '';


            //Destinataire de l'emai mutuelle
            $destinataire = [];
            $mails = Services::where('service', '=', 'Recrutement')->first()->mails;
            foreach ($mails as $mail) {
                array_push($destinataire, $mail->mail);
            }

            //Email client
            Mail::send('Recrutement::mails.client', $data, function ($message) use ($data, $prefix) {
                $message->from(config('mail.from.address'), 'Hôpital Privé de Vitry');
                $message->to($data['email'])->subject($prefix . 'Hôpital Privé de Vitry - votre candidature');
            });

            //Email admin
            Mail::send('Recrutement::mails.admin', $data, function ($message) use ($data, $prefix, $destinataire) {
                $message->from(config('mail.from.address'), 'Hôpital Privé de Vitry');
                $message->to($destinataire)->subject($prefix . 'Hôpital Privé de Vitry - une candidature sur votre site');
            });

        } catch (\Exception $e) {
            Log::error('Erreur dans l\'envoi de l\'email : ' . $e, ['Nom' => $data['nom'], 'email' => $data['email']]);
        }

    }

}