<?php
/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

use Bloom\CMS\Modules\Recrutement\Model\Recrutement;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Support\Facades\Route;

Route::group(['prefix' => 'recrutement'], function () {
    Route::get('/maj/{numPage}', function ($numPage) {
        /**
         * @var Collection $recrutements
         */
        $recrutements = Recrutement::published()->join('pages', function ($join) {
            $join->on('recrutements.id', '=', 'pages.contenu_id')
                ->where('pages.contenu_type', '=', 'recrutements');
        })
            ->join('services_clinique', 'services_clinique.id', '=', 'recrutements.service_id')
            ->latest('pages.updated_at')
            ->paginate(3, [
                'pages.titre as titre',
                'pages.pathname as pathname',
                'recrutements.id as id',
                'recrutements.updated_at as updated_at',
                'recrutements.reference as reference',
                'recrutements.contrat_type as contrat_type',
                'services_clinique.nom as service',
            ], '', $numPage);

        return $recrutements;

    })->name('recrutement_maj');

    Route::post('/save', 'FrontController@saveLead')->name('saveLead');
});