<?php
/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

namespace Bloom\CMS\Modules\Produits;

use Bloom\CMS\Core\BloomProvider;
use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\Modules\Produits\Model\Produit;
use Illuminate\Database\Eloquent\Relations\Relation;

class CmsProduitsServiceProvider extends BloomProvider
{
    protected $nom = "Prevoyance";
    protected $code = "prevoyance";
    protected $has_admin = true;
    protected $icons = "umbrella";

    public function boot(): void
    {
        parent::boot();
        // Déclaration contenu
        Relation::morphMap([
            'produits' => Produit::class,
        ]);
        Page::declareContenu('produits');

        $this->publishes([
            dirname(__DIR__) . '/public/build' => public_path('/vendor/cms-module-prevoyance')
        ], 'assets');
    }
}
