@extends('bloom.layout.admin')

@section('bodyClass', 'page-edit page-prevoyance')

@section('assets')
    <script src="{{ mix('/form.js', '/vendor/cms-module-prevoyance') }}"></script>
    <script src="/plugins/ckeditor/ckeditor.js"></script>
    <script type="text/javascript" src="/js/ckfinder/ckfinder.js"></script>
    <script>CKFinder.config({connectorPath: '/ckfinder/connector'});</script>
@endsection

@section('content')
    <div class="container-fluid">
        <div id="navbar-btns" class="mb-5 heading-text d-flex justify-content-between align-items-center sticky-top">
            <h1>{{ $produit->exists() ? '&aEcute;diter' : 'Créer' }} un produit</h1>

            <span class="wrapper-btns ml-auto">
                <a href="{{ route('admin_prevoyance_index') }}" class="btn-annuler btn btn-grisclair5 btn-primary">
                    Annuler
                </a>
                <a href="javascript:void(0);" class="btn-valider submit btn btn-grisclair5 btn-primary"
                   onclick="$('.main form').submit()">
                    Valider
                </a>
                <a href="javascript:void(0);" class="btn-publier submit btn btn-grisclair5 btn-primary"
                   onclick="publishAndSubmit()">
                    Valider et publier maintenant
                </a>
                <a href="@if($produit->exists()) {{ route('admin_prevoyance_preview', $produit) }} @else javascript:void(0); @endif"
                   target="_blank"
                   class="btn-previsualier btn btn-grisclair5 btn-primary @if(!$produit->exists()) disabled @endif"
                   title="@if(!($produit->exists())) Sauvegarder pour prévisualiser @endif">
                    Prévisualiser
                </a>
            </span>
        </div>

        <div class="content">
            <form action=" {{ route('admin_prevoyance_save', $produit) }} " method="POST" id="form"
                  enctype="multipart/form-data">
                <div class="form-group row mb-0">
                    <div class="col-6 mb-4">
                        <x-forms.input-text
                                name="titre"
                                text="Titre"
                                :value="$page->titre"
                                form="admin"
                        />
                    </div>
                    <div class="col-6 mb-4">
                        <x-forms.input-text
                                name="slug"
                                text="Slug"
                                :value="$page->slug"
                                form="admin"
                        />
                    </div>
                    <div class="col-12 mb-4">
                        <div class="wrapper-editor">
                            <x-forms.editor
                                    name="intro"
                                    text="Introduction <em>(facultatif)</em>"
                                    :value="$page->intro"
                                    form="admin"
                                    format="mini"
                            />
                        </div>
                    </div>
                    <div class="col-12 mb-4">
                        <div class="wrapper-editor">
                            <x-forms.editor
                                    name="contenu"
                                    text="Contenu"
                                    :value="$produit->contenu"
                                    form="admin"
                            />
                        </div>
                    </div>
                </div>

                <div class="form-group mb-0">
                    <div class="mb-4">
                        <div class="wrapper-editor">
                            <x-forms.editor
                                    name="mentions"
                                    text="Mentions <em>(facultatif)</em>"
                                    :value="$page->mentions"
                                    form="admin"
                                    format="mini"
                            />
                        </div>
                    </div>
                </div>

                <div class="form-group row mb-0">
                    <div class="col-6 mb-4">
                        <label for="dossier_id" class="control-label">
                            Localisation dans l'architecture
                        </label>

                        <div class="wrapper-inputs">
                            <select class="form-control" name="dossier_id" id="dossier_id">
                                <option value=""></option>
                                @foreach($dossiers as $dossier)
                                    <option value="{{ $dossier->id }}"
                                            @if($sante === $dossier->id) selected @endif
                                    >
                                        @for($i = $dossier->level; $i != 0; $i-- )
                                            >
                                        @endfor
                                        {{ $dossier->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>

                <div class="form-group mb-4">
                    <label class="control-label" for="date_pub">Dates de publication</label>

                    <div class="row w-75">
                        {{--{{ field.calendrier('prevoyance', 'date_pub', 'date_depub', $page) }}--}}
                    </div>
                </div>

                <div class="form-group mb-4">
                    <label for="vignette" class="control-label">Vignette</label>
                    <x-forms.input-custom-file-with-image
                            name="vignette"
                            text="Parcourir"
                            form="admin"
                            :required="$page->image_opengraph === ''"
                            :value="$page->image_opengraph"
                    />
                </div>
                {{ csrf_field() }}
            </form>
        </div>
    </div>
@endsection