@extends('bloom.layout.admin')

@php
    use \Carbon\Carbon;
@endphp

@section('content')
    <div class="container-fluid">
        <div id="navbar-btns" class="mb-5 heading-text d-flex justify-content-between align-items-center sticky-top">
            <h1>Prévoyance</h1>

            <a href="{{ route('admin_prevoyance_edit') }}" class="btn btn-grisclair5 btn-primary">
                Créer un produit
            </a>
        </div>

        <div class="content">
            <ul class="list-nav-produits nav nav-pills mb-3">
                @foreach($sub_menu_items as $item)
                    <li class="nav-item">
                        <a href="{{ $item['href'] }}" @if($item['active']) class="active" @endif>
                            <span class="text">{{ $item['title'] }}</span>
                            <span class="badge badge-primary badge-pill">{{ $item['number'] }}</span>
                        </a>
                    </li>
                @endforeach
            </ul>

            <div class="table-responsive">
                <table class="table table-admin">
                    <thead>
                    <tr>
                        <th scope="col">Vignette</th>
                        <th scope="col">
                            <a class="order-me @if($order['item'] === 'id') sort-{{ $order['order'] }} @endif"
                               href="?orderBy=id&order=@if($order['item'] === 'id') {{ $order['order'] === 'asc' ? 'desc' : 'asc' }} @else asc @endif"
                            >
                                <span class="text">Id</span>
                                <span class="sort">
                                    <span class="bloomicon-admin-chevron-up" aria-hidden="true"></span>
                                    <span class="bloomicon-admin-chevron-down" aria-hidden="true"></span>
                                </span>
                            </a>
                        </th>
                        <th scope="col">
                            <a class="order-me @if($order['item'] === 'titre') sort-{{ $order['order'] }} @endif"
                               href="?orderBy=titre&order=@if($order['item'] === 'titre') {{ $order['order'] === 'asc' ? 'desc' : 'asc' }} @else asc @endif">
                                <span class="text">Titre</span>
                                <span class="sort">
                                    <span class="bloomicon-admin-chevron-up" aria-hidden="true"></span>
                                    <span class="bloomicon-admin-chevron-down" aria-hidden="true"></span>
                                </span>
                            </a>
                        </th>
                        <th scope="col">Chemin archi</th>
                        <th scope="col">
                            <a class="order-me @if($order['item'] === 'created_at') sort-{{ $order['order'] }} @endif"
                               href="?orderBy=created_at&order=@if($order['item'] === 'created_at') {{ $order['order'] === 'asc' ? 'desc' : 'asc' }} @else asc @endif">
                                <span class="text">Créé le</span>
                                <span class="sort">
                                    <span class="bloomicon-admin-chevron-up" aria-hidden="true"></span>
                                    <span class="bloomicon-admin-chevron-down" aria-hidden="true"></span>
                                </span>
                            </a>
                        </th>
                        <th scope="col">
                            <a class="order-me @if($order['item'] === 'updated_at') sort-{{ $order['order'] }} @endif"
                               href="?orderBy=updated_at&order=@if($order['item'] === 'updated_at') {{ $order['order'] === 'asc' ? 'desc' : 'asc' }} @else asc @endif">
                                <span class="text">Modifié le</span>
                                <span class="sort">
                                    <span class="bloomicon-admin-chevron-up" aria-hidden="true"></span>
                                    <span class="bloomicon-admin-chevron-down" aria-hidden="true"></span>
                                </span>
                            </a>
                        </th>
                        <th scope="col">
                            <a class="order-me @if($order['item'] === 'to_publish_at') sort-{{ $order['order'] }} @endif"
                               href="?orderBy=to_publish_at&order=@if($order['item'] === 'to_publish_at') {{ $order['order'] === 'asc' ? 'desc' : 'asc' }} @else asc @endif">
                            <span class="text">
                                    Dates de<br>
                                    publication
                                </span>
                                <span class="sort">
                                    <span class="bloomicon-admin-chevron-up" aria-hidden="true"></span>
                                    <span class="bloomicon-admin-chevron-down" aria-hidden="true"></span>
                                </span>
                            </a>
                        </th>
                        <th scope="col" colspan="2"></th>
                    </tr>
                    </thead>
                    <tbody>
                    @if(count($produits) > 0)
                        @foreach($produits as $produit)
                            <tr>
                                <td><img src="{{ $produit->page->image_opengraph }}" alt="" class="img-fluid"></td>
                                <td>{{ $produit->id }}</td>
                                <td>{{ $produit->page->titre }}</td>
                                <td>
                                    @if($produit->page->dossier)
                                        {{ str_replace('/', ' > ', $produit->page->dossier->full_pathname) }}
                                    @endif
                                </td>
                                <td>
                                    <span class="tooltip-elmt d-inline-block" data-toggle="tooltip"
                                          data-placement="bottom" title="{{ $produit->page->cree_par->name }}">
                                        {{ Carbon::parse($produit->page->created_at)->format('d/m/Y') }}
                                    </span>
                                </td>
                                <td>
                                    <span class="tooltip-elmt d-inline-block" data-toggle="tooltip"
                                          data-placement="bottom" title="{{ $produit->page->deriere_modification_par->name }}">
                                        {{ Carbon::parse($produit->page->updated_at)->format('d/m/Y') }}
                                    </span>
                                </td>
                                <td>
                                    @if($produit->page->to_publish_at)
                                        <span class="tooltip-elmt d-inline-block">
                                            du {{ Carbon::parse($produit->page->to_publish_at)->format('d/m/Y') }}<br>
                                            au {{ Carbon::parse($produit->page->to_unpublish_at)->format('d/m/Y') }}
                                        </span>
                                    @endif
                                </td>
                                <td class="btn-group-cta btn-group-sm text-right">
                                    <x-action-list
                                        :actions="$actions"
                                        :item="$produit"
                                    />
                                </td>
                                @if(isset($sub_actions) && count($sub_actions) > 0)
                                    <td>
                                        <x-action-dropdown
                                            :id="'dropdownMenu0' . $loop->index"
                                            :actions="$sub_actions"
                                            :item="$produit"
                                        />
                                    </td>
                                @endif
                            </tr>
                        @endforeach
                    @endif
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection
