<?php

use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\Modules\Produits\Model\Produit;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class ProduitMorph extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $produits = Produit::all();
        Schema::table('produits', function (Blueprint $table) {
            $table->dropColumn('page_id');
        });

        foreach ($produits as $produit) {
            /**
             * @var Page $page
             */
            $page = Page::find($produit->page_id);
            if ($page) {
                $page->contenu()->associate($produit);
                $page->save();
            }
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('produits', function (Blueprint $table) {
            $table->integer('page_id', false, true);
        });
    }
}
