<?php
/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

use Illuminate\Support\Facades\Route;

Route::group(['prefix' => config('app.admin'), 'middleware' => ['auth'], 'namespace' => 'Bloom\CMS\Modules\Produits\Http\Controllers'], function () {
    Route::group(['prefix' => 'produits'], function () {
        Route::get('/', 'AdminController@index')->name('admin_prevoyance_index');
        Route::get('/programmed', 'AdminController@programmed')->name('admin_prevoyance_programmes');
        Route::get('/encours', 'AdminController@encours')->name('admin_prevoyance_encours');
        Route::get('/archived', 'AdminController@archived')->name('admin_prevoyance_archived');
        Route::get('/edit/{produit?}', 'AdminController@edit')->name('admin_prevoyance_edit');
        Route::post('/edit/{produit?}', 'AdminController@save')->name('admin_prevoyance_save');
        Route::get('/{produit}/preview', 'AdminController@preview')->name('admin_prevoyance_preview');
        Route::get('/{produit}/publish', 'AdminController@publish')->name('admin_prevoyance_publish');
        Route::get('/{produit}/unpublish', 'AdminController@unpublish')->name('admin_prevoyance_unpublish');
        Route::get('/{produit}/archive', 'AdminController@archive')->name('admin_prevoyance_archive');
        Route::get('/{produit}/duplicate', 'AdminController@duplicate')->name('admin_prevoyance_duplicate');
        Route::get('/{produit}/delete', 'AdminController@delete')->name('admin_prevoyance_delete');
    });
});