<?php
/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

namespace Bloom\CMS\Modules\Produits;

use Bloom\CMS\Modules\Architecture\Model\Module;
use Bloom\CMS\Modules\Architecture\Model\Page;
use Bloom\CMS\Modules\Produits\Http\Middleware\ModuleMiddleware;
use Bloom\CMS\Modules\Produits\Model\Produit;
use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Schema;

class CmsProduitsServiceProvider extends \Illuminate\Support\ServiceProvider
{

    public function register(): void
    {
        $this->loadFactoriesFrom(dirname(__DIR__) . '/database/factories');
        $this->loadMigrationsFrom(dirname(__DIR__) . '/database/migrations');
        $this->loadViewsFrom(dirname(__DIR__) . '/resources/views', 'Produits');
        $dirname = dirname(__DIR__) . '/routes';
        foreach (scandir($dirname) as $file) {
            if (!in_array($file, ['.', '..'])) {
                Route::group(['middleware' => ['web', ModuleMiddleware::class]], function () use ($dirname, $file) {
                    $this->loadRoutesFrom($dirname . '/' . $file);
                });
            }
        }

        $this->publishes([
            dirname(__DIR__) . '/public' => public_path('/vendor/cms-module-produits')
        ], 'assets');
    }

    public static function getModule()
    {
        if (Schema::hasTable('modules')) {
            $module = Module::nom('prevoyance')->firstOrCreate([
                'nom'        => 'prevoyance',
                'nom_public' => 'Prevoyance',
                'route'      => 'admin_prevoyance_index',
            ]);
            if (!$module->exists) {
                $module->active = 1;
                $module->save();
            }

            return $module;
        }

        return false;
    }

    public function boot(): void
    {

        // Déclaration contenu
        Relation::morphMap([
            'produits' => Produit::class,
        ]);
        Page::declareContenu('produits');
        self::getModule();
    }

}