<?php

namespace Bloom\CMS\HPV\Praticiens;

use Bloom\CMS\Core\BloomProvider;
use Bloom\CMS\Core\Contenus\PageStatique;
use Bloom\CMS\Core\Contenus\Statut;
use Bloom\CMS\Core\Helpers\Actions;
use Bloom\CMS\Core\Helpers\TableHeader;
use Bloom\CMS\Core\Helpers\WorkflowsFactory;
use Bloom\CMS\HPV\Praticiens\Http\Controllers\FrontController;
use Bloom\CMS\Core\Http\Dossier;
use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\HPV\Praticiens\Model\Praticien;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

class PraticiensServiceProvider extends BloomProvider
{
    public const DOSSIER_NAME = 'Praticiens';
    protected $nom = "Praticiens";
    protected $code = "praticien";
    protected $icons = "?";

    public function boot()
    {
        parent::boot();
        Page::declareContenu(Praticien::class);
        if (Schema::hasTable('page_statiques') && !PageStatique::query()->where('controller', '=', FrontController::class . '@index')->exists()) {
            $statique = new PageStatique(
                [
                    'display_type' => 'Praticiens',
                    'action'       => 'Gérer les praticiens',
                    'route'        => 'admin_praticien_index',
                    'controller'   => FrontController::class . '@index'
                ]
            );
            $statique->save();
            // Création du dossier avec un nom filtrable pour le rattachement des pages enfants
            if (!DB::table('dossiers')
                ->where('name', '=', 'Praticiens')->exists()) {
                $dossier = new Dossier();
                $dossier->type = "simple";
                $dossier->name = self::DOSSIER_NAME;
                $dossier->slug = 'praticiens';
                $dossier->save();
            }
            else {
                $dossier = Dossier::where('name', '=', 'Praticiens')->first();
            }
            // Création de la page index
            $page = new Page();
            $page->contenu()->associate($statique);
            $page->dossier()->associate($dossier);
            $page->titre = "Nos praticiens";
            $page->slug = "";
            $page->meta_description = "";
            $page->meta_titre = "";
            $page->intro = "<p>Texte d'introduction de la page Praticiens. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam at porttitor sem.</p>";
            $page->multiplicity = 1;
            $page->statut_id = Statut::PUBLIE;
            $page->is_index = 1;
            $page->save();
        }
        $factory = new WorkflowsFactory(Praticien::class);
        $this->declarePublishedWorkflow($factory);
        $this->declareEnCoursWorkflow($factory);
        $this->declareArchivedWorkflow($factory);
        $this->haveGenericIndex($factory);
    }

    public function declarePublishedWorkflow(WorkflowsFactory $factory)
    {
        //select p.* from praticiens as p inner Join pages on p.id = pages.contenu_id and pages.contenu_type = "Bloom\\CMS\\HPV\\Praticiens\\Model\\Praticien" where pages.statut_id = 1 order by p.nom
        $factory
            //#region PRATICIEN_PUB
            ->add('Publiés', "PRATICIEN_PUB")
            ->statement('select p.*
                                from praticiens as p
                                inner Join pages on p.id = pages.contenu_id and pages.contenu_type = "Bloom\\\\CMS\\\\HPV\\\\Praticiens\\\\Model\\\\Praticien"
                                where pages.statut_id = ' . Statut::PUBLIE . '
                                order by p.nom')
            ->edition('admin_praticien_edit', 'Créer un praticien')
            ->setAction(
                (new Actions())
                    ->addAction('Modifier', 'admin_praticien_edit')
                    ->addNewTabAction('Prévisualiser', 'admin_praticien_preview')
            )->setSubActions(
                (new Actions())
                    ->addAction('Dupliquer', 'admin_praticien_duplicate', 'bloomicon-admin-copy')
                    ->addAction('Dépublier', 'admin_praticien_unpublish', 'bloomicon-admin-arrow-down-left')
                    ->addAction('Archiver', 'admin_praticien_archive', 'bloomicon-admin-archive')
            )->setHeaders(
                [
                    (new TableHeader('Vignette', 'page.image_opengraph'))->isImage(),
                    (new TableHeader('Id', 'id'))->canOrder(),
                    (new TableHeader('Nom', 'page.titre'))->canOrder(),
                    (new TableHeader('Spécialité(s)', 'specialites.nom'))->canOrder(),
                    (new TableHeader('Créé le', 'created_at'))->canOrder()->haveTitle('page.cree_par.name'),
                    (new TableHeader('Modifié le', 'updated_at'))
                        ->canOrder()->haveTitle('page.derniere_modification_par.name'),
                    (new TableHeader('Dates de<br> publication', 'page.to_publish_at'))->canOrder(),
                ]
            )
            ->push();
        //#endregion
    }

    public function declareEnCoursWorkflow(WorkflowsFactory $factory)
    {
        $factory
            //#region PRATICIEN_EN_COURS
            ->add('En cours de rédaction', "PRATICIEN_EN_COURS")
            ->statement('select p.*
                                from praticiens as p
                                inner Join pages on p.id = pages.contenu_id and pages.contenu_type = "Bloom\\\\CMS\\\\HPV\\\\Praticiens\\\\Model\\\\Praticien"
                                where pages.statut_id = ' . Statut::EN_COURS . '
                                order by p.updated_at DESC')
            ->edition('admin_praticien_edit', 'Créer un praticien')
            ->setAction(
                (new Actions())
                    ->addAction('Modifier', 'admin_praticien_edit')
                    ->addNewTabAction('Prévisualiser', 'admin_praticien_preview')
            )->setSubActions(
                (new Actions())
                    ->addAction('Dupliquer', 'admin_praticien_duplicate', 'bloomicon-admin-copy')
                    ->addAction('Publier', 'admin_praticien_publish', 'bloomicon-admin-arrow-up-right')
                    ->addAction('Archiver', 'admin_praticien_archive', 'bloomicon-admin-archive')
            )->setHeaders(
                [
                    (new TableHeader('Vignette', 'page.image_opengraph'))->isImage(),
                    (new TableHeader('Id', 'id'))->canOrder(),
                    (new TableHeader('Nom', 'page.titre'))->canOrder(),
                    (new TableHeader('Spécialité(s)', 'specialites.nom'))->canOrder(),
                    (new TableHeader('Créé le', 'created_at'))->canOrder()->haveTitle('page.cree_par.name'),
                    (new TableHeader('Modifié le', 'updated_at'))
                        ->canOrder()->haveTitle('page.derniere_modification_par.name'),
                    (new TableHeader('Dates de<br> publication', 'page.to_publish_at'))->canOrder(),
                ]
            )
            ->push();
        //#endregion
    }

    public function declareArchivedWorkflow($factory)
    {
        $factory
            //#region PRATICIEN_ARCHIVED
            ->add('Archivés', "PRATICIEN_ARCHIVED")
            ->statement('select p.*
                                from praticiens as p
                                inner Join pages on p.id = pages.contenu_id and pages.contenu_type = "Bloom\\\\CMS\\\\HPV\\\\Praticiens\\\\Model\\\\Praticien"
                                where pages.statut_id = ' . Statut::ARCHIVE . '
                                order by p.updated_at DESC')
            ->edition('admin_praticien_edit', 'Créer un praticien')
            ->setAction(
                (new Actions())
                    ->addAction('Désarchiver', 'admin_praticien_unpublish')
                    ->addAction('Supprimer', 'admin_praticien_delete')
            )->setSubActions(
                (new Actions())
                    ->addAction('Dupliquer', 'admin_praticien_duplicate', 'bloomicon-admin-copy')
            )->setHeaders(
                [
                    (new TableHeader('Vignette', 'page.image_opengraph'))->isImage(),
                    (new TableHeader('Id', 'id'))->canOrder(),
                    (new TableHeader('Nom', 'page.titre'))->canOrder(),
                    (new TableHeader('Spécialité(s)', 'specialites.nom'))->canOrder(),
                    (new TableHeader('Créé le', 'created_at'))->canOrder()->haveTitle('page.cree_par.name'),
                    (new TableHeader('Modifié le', 'updated_at'))
                        ->canOrder()->haveTitle('page.derniere_modification_par.name'),
                    (new TableHeader('Dates de<br> publication', 'page.to_publish_at'))->canOrder(),
                ]
            )
            ->push();
        //#endregion
    }
}

