<?php

namespace Bloom\CMS\HPV\Praticiens\Http\Controllers;

use Bloom\CMS\Core\Contenus\Statut;
use Bloom\CMS\Core\Helpers\Actions;
use Bloom\CMS\Core\Helpers\Workflow;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Routing\Controller;
use Bloom\CMS\Core\Http\Dossier;
use Bloom\CMS\Core\Http\Page;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Log;
use Carbon\Carbon;
use Bloom\CMS\HPV\Praticiens\Model\Praticien;
use Bloom\CMS\HPV\Cliniques\Model\Clinique;
use Bloom\CMS\HPV\Specialites\Model\Specialite;
use Bloom\CMS\HPV\Praticiens\PraticiensServiceProvider;
use Illuminate\Support\Facades\Auth;

class AdminController extends Controller
{
    public function edit(Praticien $praticien)
    {
        $jours = [
            ["val"=>"lundi", "name"=>"Lundi"],
            ["val"=>"mardi", "name"=>"Mardi"],
            ["val"=>"mercredi", "name"=>"Mercredi"],
            ["val"=>"jeudi", "name"=>"Jeudi"],
            ["val"=>"vendredi", "name"=>"Vendredi"],
            ["val"=>"samedi", "name"=>"Samedi"],
        ];
        $specialites_all = Specialite::published()->get();
        $specialites = $praticien->specialites;

        $horaires = $praticien->horaires;
        $cliniques = Clinique::published()->get();
        return view('Praticien::admin.edit', compact('praticien', 'cliniques', 'jours', 'horaires', 'specialites', 'specialites_all'));
    }

    public function save(Praticien $praticien)
    {
        $statut = request('statut_id', Statut::EN_COURS);
        $praticien->nom = request('nom');
        $praticien->prenom = request('prenom');
        $praticien->doctolib = request('doctolib');
        $praticien->cliniques_id = request('cliniques_id');
        $praticien->telephone = request('telephone');
        $praticien->horaires = request('horaires');
        $praticien->description = request('autres_infos', '');
        $praticien->photo = request('photo', '');
        $praticien_id = $praticien->id;
        $praticien->save();

        if (!$praticien_id) {
            $page = new Page();
            $page->contenu()->associate($praticien);
            $page->multiplicity = "1";
            $page->meta_titre = "";
            $page->meta_description = "";
            $page->dossier()->associate(Dossier::query()->where('name', '=', PraticiensServiceProvider::DOSSIER_NAME)->first());
            $page->created_by = Auth::id();
        } else {
            $page = $praticien->page;
        }

        $page->titre = request('prenom')." ".request('nom');
        $page->slug = request('slug');
        $page->intro = request('introduction', '');
        $page->mentions = request('mentions_legales', '');
        $page->image_opengraph = request('vignette', '');
        $page->to_publish_at = request('date_pub');
        $page->to_unpublish_at = request('date_depub');

        if (request('date_pub') && Carbon::createFromFormat('Y-m-d', request('date_pub'))->isAfter(now())) {
            $statut = 2;
        }
        if ($statut == 1) {
            $page->to_publish_at = now();
        }
        $page->statut_id = $statut;
        $page->last_modified_by = Auth::id();
        $page->save();

        $praticien->specialites()->sync(json_decode(request('specialites'), true));

        if ((int)$praticien->page->statut_id === Statut::PUBLIE) {
            return redirect()->route('admin_praticien_index');
        }

        $workflow = Workflow::query()->where('code', '=', 'PRATICIEN_EN_COURS')->first();

        return redirect()->route('admin_praticien_index', $workflow);
    }

    public function preview(Praticien $praticien)
    {
        return $praticien->getHandler()->single($praticien);
    }

    public function duplicate(Praticien $praticien)
    {
        $dub = $praticien->replicate(['created_at', 'updated_at', 'created_by', 'last_modified_by']);
        $dub->nom = $praticien->nom . ' - Copie';
        $dub->save();

        $page = new Page();
        $page->titre = $praticien->page->titre . " - Copie";
        $page->slug = $praticien->page->slug . "-copie";
        $page->meta_description = "";
        $page->intro = $praticien->page->intro;
        $page->mentions = $praticien->page->mentions;
        $page->meta_titre = "";
        $page->multiplicity = "1";
        $page->statut_id = $praticien->page->statut_id;
        $page->to_publish_at = $praticien->page->to_publish_at;
        $page->to_unpublish_at = $praticien->page->to_unpublish_at;
        $page->dossier_id = $praticien->page->dossier_id;
        $page->contenu()->associate($dub);
        $page->save();

        return redirect()->back();
    }

    public function publish(Praticien $praticien)
    {
        $praticien->page->statut_id = Statut::PUBLIE;
        $praticien->page->to_publish_at = now();
        $praticien->page->save();

        return redirect()->back();
    }

    public function unpublish(Praticien $praticien)
    {
        $praticien->page->statut_id = Statut::EN_COURS;
        $praticien->page->to_unpublish_at = now();
        $praticien->page->save();

        return redirect()->back();
    }

    public function archive(Praticien $praticien)
    {
        $praticien->page->statut_id = Statut::ARCHIVE;
        $praticien->page->to_unpublish_at = now();
        $praticien->page->save();

        return redirect()->back();
    }

    public function delete(Praticien $praticien)
    {
        $praticien->page->statut_id = Statut::SUPPRIMER;
        $praticien->page->save();

        return redirect()->back();
    }
}
