<?php

namespace Bloom\CMS\HPV\Praticiens\Model;

use Bloom\CMS\Core\Contenus\Contenu;
use Bloom\CMS\Core\Contenus\ContenuHandler;
use Bloom\CMS\Core\Contenus\IsContenu;
use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\HPV\Specialites\Model\Specialite;
use Bloom\CMS\HPV\Cliniques\Model\Clinique;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\{Builder, Collection, Model};
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Log;

/**
 * Class Praticien
 *
 * @package Bloom\CMS\HPV\Praticiens\Model
 *
 * @property int    $id
 * @property string $nom
 * @property string $prenom
 * @property string $doctolib
 * @property string $photo
 * @property int    $cliniques_id
 * @property string $horaires
 * @property string $telephone
 * @property string $description
 * @property Carbon $created_at
 * @property Carbon $updated_at
 *
 * @property Page   $page
 */
class Praticien extends Model implements Contenu
{
    protected $casts = [
        'horaires' => 'array',
    ];

    protected $appends = ['specialites_str'];


    use IsContenu;

    public function getHandler(): ContenuHandler
    {
        return new class implements ContenuHandler {

            public function single(Contenu $contenu): Response
            {
//                $cliniques = $contenu->cliniques;
                $page = $contenu->page;
                $breadcrumbElements = [
                    ["name" => 'Dr ' . $page->titre, 'url' => '']
                ];
                if ($page->dossier) {
                    $dossier = $page->dossier;
                    while ($dossier !== null) {
                        $breadcrumbElements[] = ['name' => $dossier->name, 'url' => $dossier->full_pathname];
                        $dossier = $dossier->parent;
                    }
                }

                $breadcrumbElements = array_reverse($breadcrumbElements);

                return response(
                    view(
                        'Praticien::front.index',
                        ['praticien' => $contenu, 'page' => $page, 'breadcrumbElements' => $breadcrumbElements]
                    )
                );
            }

            public function multiple(Collection $contenus): Response
            {
                Log::warning('multiple praticiens not unhandled', ['contenu' => $contenus]);

                return \response();
            }

            public function ensemble()
            {
                Log::warning('ensemble praticiens not unhandled');
            }
        };
    }

    public function scopePublished(Builder $query)
    {
        return $this->scopeStatus($query, 1);
    }


    public function scopeArchived(Builder $query)
    {
        return $this->scopeStatus($query, 0);
    }

    public function scopeStatus(Builder $query, int $status)
    {
        return $query->whereHas('page', function (Builder $query) use ($status) {
            return $query->where('statut_id', '=', $status);
        });
    }

    public function scopeProgrammed(Builder $query)
    {
        return $query->whereHas('page', function (Builder $query) {
            return $query->whereNotNull('to_publish_at')
                ->where('statut_id', '=', 2);
        });
    }

    public function scopeNotProgrammed(Builder $query)
    {
        return $query->whereHas('page', function (Builder $query) {
            return $query->whereNull('to_publish_at');
        });
    }

    public function specialites()
    {
        return $this->belongsToMany(Specialite::class);
    }

    public function clinique()
    {
        return $this->belongsTo(Clinique::class, "cliniques_id");
    }

    public function getSpecialitesStrAttribute()
    {
        $array_spec = [];
        foreach ($this->specialites as $specialite) {
            array_push($array_spec, trim($specialite->nom));
        }
        asort($array_spec);
        $str = implode(", ", $array_spec);

        return $str;
    }
}
