function add_horaire(id) {
    $("#block_jour_horaires" + id + " .row").append(
        '<div class="col-4 d-flex pr-0 mt-0 mb-3 col-horaire-debut">\
            <div class="w-100">\
                <div class="row">\
                    <div class="mb-0 col-6">\
                        de <input required type="number" name="horaires' + id + '_heure_debut0" class="form-control d-inline ml-2" />h \
                        <input required type="number" class="form-control d-inline" name="horaires' + id + '_minute_debut0"/>m\
                    </div>\
                    <div class="mb-0 col-6">\
                        à <input required type="number" name="horaires' + id + '_heure_fin0" class="form-control d-inline ml-2"/>h \
                        <input required type="number" class="form-control d-inline" name="horaires' + id + '_minute_fin0"/>m\
                    </div>\
                </div>\
            </div>\
        </div>\
        <div class="col-4 d-flex pr-0 mt-0 mb-3 col-horaire-end">\
            <div class="wrapper-input-prepend w-100">\
                <div class="row">\
                    <div class="col-12">\
                        <a href="javascript:void(0)" id="horaires_add_btn' + id + '" class="btn btn-add d-inline-flex mt-1 mb-0 add-plage-horaire">\
                            <span>Ajouter une plage horaire</span>\
                        </a>\
                    </div>\
                </div>\
            </div>\
            <div class="wrapper-input-append d-flex justify-content-end align-items-end pr-15 delete-horaire">\
                <a href="javascript:void(0)" class="btn btn-remove" id="remove-jour_horaires' + id +'">\
                    <span class="bloomicon-admin-trash-2"></span>\
                </a>\
            </div>\
        </div>'
    );

    $("#remove-jour_horaires" + id).click(function() {
        delete_plage_horaire($(this).attr('id').replace('remove-', ''));
    });

    $("#horaires_add_btn" + id).click(function() {
        add_plage_horaire(id);
    });
    current_timetable_id++;
    let new_block = $("#block_jour_horaires").clone().appendTo("#blocks_horaires");
    new_block.attr('id', 'block_jour_horaires' + current_timetable_id);
    new_block.find('select').attr('name', 'jour_horaires'+current_timetable_id).attr('id', 'jour_horaires' + current_timetable_id).change(function() {
        select_jour_changed_callback($(this));
    }).val("");
}

function add_plage_horaire(id) {
    $("#horaires_add_btn" + id).remove();
    $("#block_jour_horaires" + id + " .col-horaire-end .row").append(
        '<div class="mb-0 col-6">\
            et de <input required type="number" name="horaires' + id + '_heure_debut1" class="form-control d-inline ml-2" />h \
            <input required type="number" class="form-control d-inline" name="horaires' + id + '_minute_debut1"/>m\
        </div>\
        <div class="mb-0 col-6">\
            à <input required type="number" name="horaires' + id + '_heure_fin1" class="form-control d-inline ml-2" />h \
            <input required type="number" class="form-control d-inline" name="horaires' + id + '_minute_fin1"/>m\
        </div>'
    );
}

function delete_plage_horaire(id) {
    $("#block_" + id).remove();
}

function select_jour_changed_callback(select) {
    select.attr('required', true)
    let id = select.attr('id').replace("jour_horaires", '');
    if ($("input[name=horaires" + id + "_heure_debut0").length == 0) {
        add_horaire(id);
    }
}

function generate_horaires_json() {
    let horaires = [];
    let days = [];
    $('select[name^="jour_horaires"]').each(function() {
        let idx = $(this).attr('id').replace('jour_horaires', '');
        if ($('input[name="horaires'+idx+'_heure_debut0"]').length == 0) {
            return;
        }
        let day = $('select[name="jour_horaires' + idx + '"]').val();
        if (days.indexOf(day) !== -1) {
            horaires["error"] = true;
            return;
        }
        let horaire = {
            "day":day
        };
        let ranges = [
            {
                "hstart":$('input[name="horaires'+idx+'_heure_debut0"]').val(),
                "mstart":$('input[name="horaires'+idx+'_minute_debut0"]').val(),
                "hend":$('input[name="horaires'+idx+'_heure_fin0"]').val(),
                "mend":$('input[name="horaires'+idx+'_minute_fin0"]').val()
            }
        ];
        if ($('input[name="horaires'+idx+'_heure_debut1"]').length > 0) {
            ranges.push({
                "hstart":$('input[name="horaires'+idx+'_heure_debut1"]').val(),
                "mstart":$('input[name="horaires'+idx+'_minute_debut1"]').val(),
                "hend":$('input[name="horaires'+idx+'_heure_fin1"]').val(),
                "mend":$('input[name="horaires'+idx+'_minute_fin1"]').val()
            });
        }
        horaire.ranges = ranges;
        horaires.push(horaire);
        days.push(day);
    });
    return horaires;
}

function generate_specialites_json() {
    let specialites = [];
    $('select[name^=specialite]').each(function() {
        let idx = $(this).attr('id').replace('specialite', '');
        console.log(idx);
        if ($("#remove-specialite"+idx).length == 1) {
            console.log($(this).val());
            console.log(specialites);
            if (specialites.indexOf($(this).val()) !== -1) {
                specialites.push(-1);
                return false;
            }
            specialites.push($(this).val());
        }
    });
    if (specialites.indexOf(-1) !== -1) {
        return false;
    }
    return specialites;
}

function select_specialite_changed_callback(select) {
    select.attr('required', true)
    let id = select.attr('id').replace("specialite", '');
    if ($("#remove-specialite"+id).length == 0) {
        $("#block_specialite"+id).append(
            '<div class="wrapper-input-append d-flex justify-content-end pr-15 delete-specialite">\
            <a href="javascript:void(0)" class="btn btn-remove" id="remove-specialite'+id+'">\
            <span class="bloomicon-admin-trash-2"></span>\
            </a>\
            </div>'
            );
        $("#block_specialite"+id).find(".col-6").attr('class', 'col-6 mb-2');
        $("#remove-specialite"+id).click(function() {
            delete_specialite(id);
        });
        current_specialite_id++;
        let new_block = $("#block_specialite").clone().appendTo("#block_specialites");
        new_block.attr('id', 'block_specialite'+current_specialite_id);
        new_block.find('select').attr('specialite', 'specialite'+current_specialite_id).attr('id', 'specialite'+current_specialite_id).change(function() {
            select_specialite_changed_callback($(this));
        }).val("");
    }
}

function delete_specialite(id) {
    $("#block_specialite"+id).remove();
}


document.addEventListener('DOMContentLoaded', function () {
    $("#form").submit(function() {
        if ($("input[name=horaires]").length) {
            $("input[name=horaires]").remove();
        }
        let horaires = generate_horaires_json();
        $("#horaires-error").hide();
        if (horaires["error"] !== undefined) {
            $("#horaires-error").show();
            return false;
        }
        $(this).append("<input type='hidden' name='horaires' value='"+JSON.stringify(horaires)+"'></input>");
        if ($("input[name=specialites]").length) {
            $("input[name=specialites]").remove();
        }
        let specialites = generate_specialites_json();
        $("#specialite-error").hide();
        if (specialites === false) {
            $("#specialite-error").show();
            return false;
        }
        $(this).append("<input type='hidden' name='specialites' value='"+JSON.stringify(specialites)+"'></input>");
        return true;
    });

    $("a[id^=remove]").click(function() {
        delete_plage_horaire($(this).attr('id').replace('remove-', ''));
    });

    $("select[name^=jour_horaires]").change(function() {
        select_jour_changed_callback($(this));
    });

    $("a[id^=horaires_add_btn]").click(function() {
        add_plage_horaire($(this).attr('id').replace('horaires_add_btn', ''));
    });

    $("select[name^=specialite]").change(function() {
        select_specialite_changed_callback($(this));
    });

    $("a[id^=remove-specialite]").click(function() {
        delete_specialite($(this).attr('id').replace('remove-specialite', ''));
    });

});