<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddPraticienSpecialiteTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('praticien_specialite', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('praticien_id');
            $table->unsignedBigInteger('specialite_id');

            $table->foreign(['praticien_id'])->on('praticiens')->references('id');
            $table->foreign(['specialite_id'])->on('specialites')->references('id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('praticien_specialite');
    }
}
