<?php
/**
 *  * Created by : Jérôme Bonnier
 * Created at : 25/02/2021
 *
 * In : PhpStorm
 */

namespace Bloom\CMS\HPV\Praticiens\Http\Controllers;

use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\HPV\Cliniques\Model\Clinique;
use Bloom\CMS\HPV\Praticiens\Model\Praticien;
use Bloom\CMS\HPV\Specialites\Model\Specialite;
use Illuminate\Routing\Controller;

class FrontController extends Controller
{
    public function index(Page $page)
    {
        $praticiens = Praticien::with(['specialites', 'page'])
            ->published()
            ->orderBy('nom', 'asc')
            ->get();


        $cliniques = Clinique::all();
        $specialites = Specialite::published()->ordreBy('nom', 'asc')->get();


        $breadcrumbElements = [["name" => 'Nos Praticiens', 'url' => '']];
        $dossier = $page->dossier;
        while ($dossier !== null and $page->is_index === false) {
            $breadcrumbElements[] = ['name' => $dossier->name, 'url' => $dossier->full_pathname];
            $dossier = $dossier->parent;
        }

        $breadcrumbElements = array_reverse($breadcrumbElements);

        return view('Praticien::front.listing', compact('praticiens', 'breadcrumbElements', 'page', 'cliniques', 'specialites'));
    }

}