<?php

namespace Bloom\CMS\HPV\Praticiens;

use Bloom\CMS\Core\BloomProvider;
use Bloom\CMS\Core\Contenus\PageStatique;
use Bloom\CMS\Core\Contenus\Statut;
use Bloom\CMS\HPV\Praticiens\Http\Controllers\FrontController;
use Bloom\CMS\Core\Http\Dossier;
use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\HPV\Praticiens\Model\Praticien;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

class PraticiensServiceProvider extends BloomProvider
{
    public const DOSSIER_NAME = 'Praticiens';
    protected $nom = "Praticiens";
    protected $code = "praticien";
    protected $icons = "?";

    public function boot()
    {
        parent::boot();
        Page::declareContenu(Praticien::class);
        if (Schema::hasTable('page_statiques') && !PageStatique::query()->where('controller', '=', FrontController::class . '@index')->exists()) {
            $statique = new PageStatique(
                [
                    'display_type' => 'Praticiens',
                    'action'       => 'Gérer les praticiens',
                    'route'        => 'admin_praticien_index',
                    'controller'   => FrontController::class . '@index'
                ]
            );
            $statique->save();
            // Création du dossier avec un nom filtrable pour le rattachement des pages enfants
            if (!DB::table('dossiers')
                ->where('name', '=', 'Praticiens')->exists()) {
                $dossier = new Dossier();
                $dossier->type = "simple";
                $dossier->name = self::DOSSIER_NAME;
                $dossier->slug = 'praticiens';
                $dossier->save();
            }
            else {
                $dossier = Dossier::where('name', '=', 'Praticiens')->first();
            }
            // Création de la page index
            $page = new Page();
            $page->contenu()->associate($statique);
            $page->dossier()->associate($dossier);
            $page->titre = "Nos praticiens";
            $page->slug = "";
            $page->meta_description = "";
            $page->meta_titre = "";
            $page->intro = "<p>Texte d'introduction de la page Praticiens. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam at porttitor sem.</p>";
            $page->multiplicity = 1;
            $page->statut_id = Statut::PUBLIE;
            $page->is_index = 1;
            $page->save();
        }
    }
}

