<?php

namespace Tests\Feature;

use Bloom\Cms\Offre\Models\Offre;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;


class OffresTest extends TestCase
{
    private $modelId1;
    private $modelId2;

    /**
     * @throws \Exception
     */
    public function setUp(): void {
        parent::setUp();

        //vérifie que la BDD est bien la colonne "ordre" dans la table offres
        $this->assertDatabaseHas('offres', [
            'ordre' => 0
        ]);

        //récupère + initialise l'ordre des offres
        $this->modelId1 =env('FIRST_MODEL_ID', 1);
        $this->modelId2 = env('SECOND_MODEL_ID', 2);

        if(empty($this->modelId1) || empty($this->modelId2)) {
            throw new \Exception("Models ID empty. ".$this->modelId1. " et ".$this->modelId2);
        }
    }
    /**
     * @return void
     */
    public function test_reorder_offres_ko_offre_innexistante()
    {
        $this->withoutMiddleware();
        $response =  $this->post('/admin/offre/reorder',
            [
                'ordre' =>[
                    [
                        "id"=> "10000001",
                        "ordre"=> 1
                    ],
                    [
                        "id"=> "10000002",
                        "ordre"=> 2
                    ]
                ]
            ]);
        $responseJson = json_decode($response->getContent(), true);
        $this->assertEquals($responseJson['status'],500);
    }
    public function test_reorder_offres_ko_sans_parametres()
    {
        $this->withoutMiddleware();
        $response =  $this->post('/admin/offre/reorder',
            [
                //vide
            ]);
        $responseJson = json_decode($response->getContent(), true);
        $this->assertEquals($responseJson['status'],500);
    }

    public function test_reorder_offres_ok()
    {
        $this->withoutMiddleware();
        $response =  $this->post('/admin/offre/reorder',
            [
                'ordre' =>[
                    [
                        "id"=> $this->modelId1,
                        "ordre"=> 1
                    ],
                    [
                        "id"=> $this->modelId2,
                        "ordre"=> 2
                    ]
                ]
            ]);
        $responseJson = json_decode($response->getContent(), true);
        $this->assertEquals($responseJson['status'],200);

        //vérifie les ordres des offres
        $offresModel1ID = Offre::where('modele_id',$this->modelId1)->get();
        $offresModel2ID = Offre::where('modele_id',$this->modelId2)->get();

        foreach ($offresModel1ID as $offre) {
            $this->assertEquals($offre->ordre,1);
        }
        foreach ($offresModel2ID as $offre) {
            $this->assertEquals($offre->ordre,2);
        }
    }
}

