<?php

namespace Bloom\Cms\Offre\Helpers;

use Illuminate\Support\Collection;

class OffreHelper
{
    public static function sortHondaAndConcess($offres_honda, $offres_concess): array
    {
        $offres = [];
        $modele_ids = [];
        // je construis la liste des model id
        foreach ($offres_honda as $offre) {
            if (!in_array($offre->modele_id, $modele_ids)) {
                $modele_ids[] = $offre->modele_id;
            }
        }
        // puis je parcours cette liste pour y mettre toutes les offres ordonnées par offre, d'abord les offres honda, puis concess
        foreach ($modele_ids as $id) {
            foreach ($offres_honda as $offre) {
                if ($offre->modele_id === $id) {
                    $offres[] = $offre;
                }
            }
            foreach ($offres_concess as $offre) {
                if ($offre->modele_id === $id) {
                    $offres[] = $offre;
                }
            }
        }

        return $offres;
    }

    public static function sortModelsByOffersOrder(Collection $modeles, Collection $offres): array
    {
        $modelsOrdered = [];
        foreach ($offres as $offre) {

            $model = $modeles->firstWhere('id', $offre->modele_id);
            if(!empty($model)  &&  !in_array($model, $modelsOrdered)) {
                $modelsOrdered[] = $model;
            }
        }
        return $modelsOrdered;
    }

}
