<?php

use Bloom\CMS\Core\Contenus\Statut;
use Bloom\Cms\Gamme\Models\Modele;
use Bloom\Cms\Offre\Models\Offre;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::group(['middleware' => 'auth:api', 'prefix' => '/api'], function ($router) {
    Route::get('/gammes', function (Request $request) {
        return Modele::where('statut_id', Statut::PUBLIE)->get();
    });
    Route::get('/modele/{id}', function (Request $request, $id) {
        return Modele::find($id);
    });
    Route::get('/offres/{id}', function (Request $request, $id) {
        return Offre::where('modele_id', $id)->where('statut_id', Statut::PUBLIE)->get();
    });
    Route::get('/offres', function (Request $request) {
        $limit = null;
        if (request('limit')) {
            $limit = request('limit');
        }
        return Offre::query()->where('statut_id', Statut::PUBLIE)->limit($limit)->get();
    });
});
