import Sortable from "sortablejs";

document.addEventListener("readystatechange", () => {
  let el = document.getElementById('sortable-wrapper'),
    option = {
      handle: '.sortable-el',
      animation: 150,
      draggable: '.sortable-section',
      onUpdate: function (e) {
        let el = $(e.from);
        let url = el.data('url');
        let items = [];
        el.find('> .sortable-section').each(function (index) {
          const [id, ordre] = Object.values(this.dataset);
          if ((ordre - 1) !== index) {
            items.push({
              id: id,
              ordre: index + 1
            });
            this.dataset.ordre = index + 1;
            $(this).find('.sortable-el').html(
              `<span class="bloomicon-admin-move"></span> ${index + 1}`
            );
          }
        });
        axios.post(url, {ordre: items}).then((Response) => {
          console.log(Response);
        }).catch((error) => {
          console.error(error);
        });
      }
    };

  if (el != null) {
    new Sortable(el, {
      ...option
    });
  }
});
