<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOffresTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('offres', function (Blueprint $table) {
            $table->id();
            $table->integer('modele_id');
            $table->string('titre', 45);
            $table->string('label_prive', 45);
            $table->text('entete');
            $table->text('part_1')->nullable();
            $table->text('part_2')->nullable();
            $table->integer('visuel_principal_id');
            $table->integer('visuel_mobile_id');
            $table->integer('vignette_1_id')->nullable();
            $table->integer('vignette_2_id')->nullable();
            $table->integer('vignette_3_id')->nullable();
            $table->dateTime('to_publish_at')->nullable();
            $table->dateTime('to_unpublish_at')->nullable();
            $table->integer('created_by');
            $table->integer('last_modified_by');
            $table->integer('statut_id');
            $table->text('mentions_legales')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('offres');
    }
}
