<?php

namespace Bloom\Cms\Offre\Repository\Eloquent;

use Bloom\CMS\Core\Contenus\Statut;
use Bloom\Cms\Offre\Models\Offre;
use Bloom\Cms\Offre\Repository\OffreRepositoryInterface;
use DateTime;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;

class OffreRepository extends BaseRepository implements OffreRepositoryInterface
{

    /**
     * OffreRepository constructor.
     *
     * @param Offre $model
     */
    public function __construct(Offre $model)
    {
        parent::__construct($model);
    }

    public function all(): Collection
    {
        return $this->model->all();
    }

    public function getPublished()
    {
        return $this->model
            ->select('*')
            ->where('statut_id', Statut::PUBLIE)
            ->get()
        ;
    }

    public function getProgrammed()
    {
        return $this->model
            ->select('*')
            ->where('statut_id', Statut::EN_COURS)
            ->whereNotNull('to_publish_at')
            ->orderBy('to_publish_at', 'DESC')
            ->get()
        ;
    }

    public function getEncours()
    {
        return $this->model
            ->select('*')
            ->where('statut_id', Statut::EN_COURS)
            ->whereNull('to_publish_at')
            ->orderBy('updated_at', 'DESC')
            ->get()
        ;
    }

    public function getArchived()
    {
        return $this->model
            ->select('*')
            ->where('statut_id', Statut::ARCHIVE)
            ->orderBy('updated_at', 'DESC')
            ->get()
        ;
    }
}
