<?php

namespace Bloom\Cms\Notification;

use Bloom\CMS\Core\BloomProvider;
use Bloom\CMS\Core\Framework\Admin\AdminMenu;
use Bloom\CMS\Core\Framework\Module;
use Bloom\Cms\Notification\Facade\GestionNotificationFacade;
use Illuminate\Support\Facades\Schema;

class CmsNotificationProvider extends BloomProvider
{
    protected $nom = "Gestionnaire de notifications";
    protected $code = "mails";
    protected $icons = "mail";

    public function boot()
    {
        parent::boot();

        if (Schema::hasTable('notifications')) {
            $this->app->singleton('notification', function () {
                return new GestionNotificationFacade();
            });
        }

        // comme on a supprimé des sous-menus, il faut faire le ménage
        // todo : ce bout de code devrait pouvoir être placé ailleurs... à voir
        if (Schema::hasTable('modules')) {
            $module = Module::where("nom", $this->code)->first();
            if ($module->nom_public !== $this->nom) {
                $module->nom_public = $this->nom;
                $module->save();
                $adminMenus = AdminMenu::where('module_id', $module->id)->get();
                foreach ($adminMenus as $adminMenu) {
                    $adminMenu->delete();
                }
            }
        }

    }
}
