<?php


namespace Bloom\Cms\Notification\Data;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Mails
 * @package Configuration\Data
 *
 * En base
 * @property int $id
 * @property string $mail
 * @property Carbon $created_at
 * @property Carbon $updated_at
 */
class Mails extends Model
{
    protected $guarded = ['id', 'service','mail', 'created_at', 'updated_at'];
    public function services()
    {
        return $this->belongsToMany(Services::class, 'mails_services', 'mails_id', 'services_id')->withPivot(['created_at', 'updated_at']);
    }
}
