@extends('bloom.layout.admin')

@section('bodyClass', 'page-edit')

@section('assets')
    {{--    @vite('resources/assets/js/notification.js', 'vendor/cms-module-mails')--}}
@endsection

@section('content')
    @if(!empty(session('message')))
        <div class="alert alert-success alert-block">
            <p>{{ session('message') }}</p>
        </div>
    @endif
    @if(!empty(session('error')))
        <div class="alert alert-danger alert-block">
            <p>{{ session('error') }}</p>
        </div>
    @endif
    @foreach (['statut', 'emails'] as $field)
        @if($errors->first($field))
            <div class="alert alert-danger alert-block">
                {{ $errors->first($field) }}
            </div>
        @endif
    @endforeach

    <div class="container-fluid">
        <div id="navbar-btns" class="mb-5 heading-text d-flex justify-content-between align-items-center sticky-top">
            <h1>Gestionnaire de notifications</h1>
        </div>
        <div class="content">
            <div class="row mb-0">
                <div class="col-2 mb-4">
                    <label class="control-label">Notification</label>
                </div>
                <div class="col-2 mb-4">
                    <label class="control-label">Activer / Désactiver l'envoi</label>
                </div>
                <div class="col-5 mb-4">
                    <label class="control-label">Destinataire(s)
                        <em>&nbsp;(séparés par des virgules)</em>
                    </label>
                </div>
                <div class="col-3 mb-4"></div>
            </div>
            @foreach($notifications as $notification)
                <div class="form-notif-{{ $notification->code }}">
                    <form method="post" id="form" action="{{ route('admin_mails_save', $notification) }}"
                          enctype="multipart/form-data">
                        {{ csrf_field() }}
                        <input name="code" value="{{ $notification->code }}" type="hidden">
                        <div class="row align-items-start mb-0">
                            <div class="col-2 mb-4">
                                {{ $notification->label }}
                            </div>
                            <div class="col-2 mb-4">
                                <x-forms.input-custom-switch
                                    name="statut"
                                    :id="$notification->id"
                                    :checked="$notification->active ?? false"
                                    text=" "
                                />
                            </div>
                            <div class="col-5 mb-4">
                                <x-forms.input-text
                                    name="emails"
                                    :text="null"
                                    :value="$notification->emails"
                                    :required="true"
                                    :disabled="$notification->active"
                                />
                            </div>
                            <div class="col-3 mb-4">
                                <div
                                    class="row control-valide-{{ $notification->code }} @if($notification->active) d-none @endif">
                                    <div class="col-6">
                                        <a href="javascript:void(0);"
                                           class="btn-valider submit btn btn-grisclair5 btn-primary"
                                           onclick="$('.form-notif-{{ $notification->code }} form').submit()">
                                            Valider
                                        </a>
                                    </div>
                                    <div class="col-6">
                                        <a href="{{ route('admin_mails_index') }}"
                                           class="btn-annuler btn btn-grisclair5 btn-primary">
                                            Annuler
                                        </a>
                                    </div>
                                </div>
                                <div
                                    class="row control-modifie-{{ $notification->code }} @if(!$notification->active) d-none @endif">
                                    <div class="col-6">
                                        <a href="javascript:void(0);"
                                           class="btn-valider submit btn btn-grisclair5 btn-primary"
                                           onclick="$('.control-valide-{{ $notification->code }}').removeClass('d-none');$('.control-modifie-{{ $notification->code }}').hide();$('.form-notif-{{ $notification->code }} #emails').prop('disabled', false);">
                                            Modifier
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            @endforeach
        </div>
    </div>
@endsection
