<?php


namespace Bloom\Cms\Notification\Http\Controllers;


use Bloom\Cms\Notification\Data\Mails;
use Bloom\Cms\Notification\Data\Services;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class MailController
{
    public function index()
    {
        $mails = Mails::all();

        return view("Mails::mail.list_mail", compact("mails"));
    }

    public function edit(Mails $mail)
    {
        $services = Services::all();
        if ($mail->exists) {
            $mail_services = $mail->services()->pluck("services_id");
        }

        return view("Mails::mail.edit_mail", compact("mail", "services", "mail_services"));
    }

    public function save(Mails $mail, Request $request)
    {
        if ($request->get('hide')) {
            $mail = Mails::where("mail", $request->hide)->first();
        }

        $validator = Validator::make($request->all(), [
            'mail' => 'required|max:60|email',
        ]);
        if ($validator->fails()) {
            return back()
                ->withInput(request()->all())
                ->withErrors($validator);
        } else {
            try {
                $count = Mails::where('mail', $request->mail)->count();
                if ($count > 0 and $request->hide != $request->mail) {
                    Session::flash('error', 'Le mail existe déjà');

                    return back();
                } else {
                    $mail->mail = request('mail');
                    $mail->save();
                    $mail->services()->detach();
                    $services = Services::all();

                    foreach ($services as $service) {
                        $listGroup = $request->input($service->service);
                        if ($listGroup == 'on') {
                            $mail->services()->attach([
                                'services_id' => $service->id,
                            ]);
                        }
                    }
                    Session::flash('message', 'Le mail ' . $request->mail . ' est bien enregistré');

                    return redirect()->route("admin_mails_index");
                }
            } catch (\Exception $e) {
                Session::flash('error', 'Une erreur est survenu lors de l\'enregistrement' . $e->getMessage());
                Log::error('Une erreur est survenu lors de l\'enregistrement: ' . $e->getMessage());

                return redirect()->route("admin_mails_index");
            }
        }
    }

    public function modale(Mails $mail)
    {
        return view("Mails::mail.modale", compact("mail"));
    }

    public function delete(Mails $mail)
    {
        if (!$mail->delete()) {
            Session::flash('error', 'Une erreur est survenue lors de la suppression du mail: ' . $mail->mail);
            Log::error('Une erreur est survenu lors de la suppression du mail: ' . $mail->mail);
        } else {
            Session::flash('message', 'Suppression réussie du mail: ' . $mail->mail);
        }

        return redirect()->route("admin_mails_index");
    }
}
