<?php


namespace Bloom\Cms\Notification\Facade;

use Bloom\Cms\Notification\Data\Conf_services;
use Bloom\Cms\Notification\Data\Configurations;
use Bloom\Cms\Notification\Data\MailsServices;
use Bloom\Cms\Notification\Data\Services;

class ConfigurationsFacade
{


    /**
     * @param array $notifications
     */
    public function newNotification($notifications)
    {

        foreach ($notifications as $notification) {
            $services = new MailsServices();
            $service = MailsServices::where("service", $notification)->count();
            if ($service < 1) {
                $services->service = $notification;
                $services->save();
            } else {
                $services = null;
            }
        }
    }
    public function updateNotification($entrances, $exit)
    {
        $i = 0;
        foreach ($entrances as $entrance) {
            $service = MailsServices::where("service", $entrance)->count();
            $info=MailsServices::where("service", $exit[$i])->count();
            if ($service == 1 and $info==0) {
                MailsServices::where("service", $entrance)->update(['service'=> $exit[$i]]);
            }
            $i++;
        }
    }
}
