<?php


namespace Bloom\Cms\Notification\Data;


use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;


/**
 * Class Services
 * @package Configuration\Data
 *
 * En base
 * @property int    $id
 * @property string $service
 * @property Carbon $created_at
 * @property Carbon $updated_at
 */
class Services extends Model
{
    protected $guarded = ['id', 'service', 'created_at', 'updated_at'];

    public function mails()
    {
        return $this->belongsToMany(
            Mails::class,
            'mails_services',
            'mails_id',
            'services_id'
        )->withPivot(['created_at', 'updated_at']);
    }
}
