<?php

namespace Bloom\Cms\Notification\Models;

use Bloom\CMS\Core\Contenus\Statut;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Notification
 * @package Bloom\Cms\Notification\Models
 *
 * @property string    $code
 * @property string    $label
 * @property string    $emails
 * @property integer   $statut
 *
 */
class Notification extends Model
{

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'code',
        'label',
        'emails',
        'statut',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    public function getActiveAttribute(): bool
    {
        return $this->statut === Statut::PUBLIE;
    }
}
