<?php

namespace Bloom\Cms\Notification\Http\Controllers;

use App\Http\Controllers\Controller;
use Bloom\CMS\Core\Contenus\Statut;
use Bloom\Cms\Notification\Models\Notification;
use Bloom\Cms\Notification\Rules\EmailsList;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

/**
 * Class NotificationController
 * @package Bloom\Cms\Notification\Http\Controllers
 */
class NotificationController extends Controller
{
    public function index()
    {
        $notifications = Notification::all();

        return view("Mails::notifications", compact('notifications'));
    }

    public function save(Notification $notification, Request $request): RedirectResponse
    {
        $validator = Validator::make($request->all(), [
            'emails' => ['required', 'max:255', new EmailsList],
        ]);
        if ($validator->fails()) {
            return back()
                ->withInput(request()->all())
                ->withErrors($validator);
        } else {
            try {
                $notification->statut = $request->get('statut') ? Statut::PUBLIE : 0;
                $notification->emails = $request->get('emails');
                $notification->save();
            } catch (\Exception $e) {
                Session::flash('error', 'Une erreur est survenu lors de l\'enregistrement' . $e->getMessage());
                Log::error('Une erreur est survenu lors de l\'enregistrement: ' . $e->getMessage());
            }
        }
        return redirect()->route("admin_mails_index");
    }
}
