<?php


namespace Bloom\Cms\Notification\Facade;

use Bloom\CMS\Core\Contenus\Statut;
use Bloom\Cms\Notification\Models\Notification;

class GestionNotificationFacade
{
    public function addGroup(string $code, string $label): void
    {
        $notification = Notification::where('code', $code)->first();

        if (is_null($notification)) {
            $notification = new Notification;
            $notification->code = $code;
            $notification->label = $label;
            $notification->statut = 0;
            $notification->save();
        }
    }

    public function getEmails(string $code): array
    {
        $notification = Notification::where('code', $code)->first();
        if (is_null($notification)) {
            return [];
        }

        return preg_split("/(,\s?)+/", $notification->emails);
    }

    public function isActive(string $code): bool
    {
        $notification = Notification::where('code', $code)->first();
        if (is_null($notification)) {
            return false;
        }

        return $notification->statut === Statut::PUBLIE;
    }
}
