<?php

namespace Bloom\Cms\Notification\Rules;

use Illuminate\Contracts\Validation\Rule;

class EmailsList implements Rule
{

    public function passes($attribute, $value)
    {
        $emails = preg_split("/(,\s?)+/", $value);
        foreach ($emails as $email) {
            if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                return false;
            }
        }
        return true;
    }

    public function message()
    {
        return 'Les emails doivent être une suite d\'emails valides séparés par une virgule';
    }
}
